/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Parameter;

public interface MatrixParameterInterface
extends Parameter {
    public double getParameterValue(int var1, int var2);

    public Parameter getParameter(int var1);

    public void setParameterValue(int var1, int var2, double var3);

    public void setParameterValueQuietly(int var1, int var2, double var3);

    public void setParameterValueNotifyChangedAll(int var1, int var2, double var3);

    public double[] getColumnValues(int var1);

    public double[][] getParameterAsMatrix();

    public int getColumnDimension();

    public int getRowDimension();

    @Override
    public double[] getParameterValues();

    default public int getParameterCount() {
        throw new RuntimeException("Not yet implemented");
    }

    public int getUniqueParameterCount();

    public Parameter getUniqueParameter(int var1);

    public void copyParameterValues(double[] var1, int var2);

    public void setAllParameterValuesQuietly(double[] var1, int var2);

    public String toSymmetricString();

    public boolean isConstrainedSymmetric();

    default public int index(int n, int n2) {
        if (n2 > this.getColumnDimension()) {
            throw new RuntimeException("Column " + n2 + " out of bounds: Compared to " + this.getColumnDimension() + "maximum size.");
        }
        if (n > this.getRowDimension()) {
            throw new RuntimeException("Row " + n + " out of bounds: Compared to " + this.getRowDimension() + "maximum size.");
        }
        return n2 * this.getRowDimension() + n;
    }

    public static double[][] getParameterAsMatrix(MatrixParameterInterface matrixParameterInterface) {
        int n = matrixParameterInterface.getRowDimension();
        int n2 = matrixParameterInterface.getColumnDimension();
        double[][] dArray = new double[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray[j][i] = matrixParameterInterface.getParameterValue(j, i);
            }
        }
        return dArray;
    }
}

