## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(boostmath)

## -----------------------------------------------------------------------------
# Mean
mean_boost(c(1, 2, 3, 4, 5))
# Variance
variance(c(1, 2, 3, 4, 5))
# Sample Variance
sample_variance(c(1, 2, 3, 4, 5))
# Mean and Sample Variance
mean_and_sample_variance(c(1, 2, 3, 4, 5))
# Skewness
skewness(c(1, 2, 3, 4, 5))
# Kurtosis
kurtosis(c(1, 2, 3, 4, 5))
# Excess Kurtosis
excess_kurtosis(c(1, 2, 3, 4, 5))
# First Four Moments
first_four_moments(c(1, 2, 3, 4, 5))
# Median
median_boost(c(1, 2, 3, 4, 5))
# Median Absolute Deviation
median_absolute_deviation(c(1, 2, 3, 4, 5))
# Interquartile Range
interquartile_range(c(1, 2, 3, 4, 5))
# Gini Coefficient
gini_coefficient(c(1, 2, 3, 4, 5))
# Sample Gini Coefficient
sample_gini_coefficient(c(1, 2, 3, 4, 5))
# Mode
mode(c(1, 2, 2, 3, 4))

## -----------------------------------------------------------------------------
# Covariance
covariance(c(1, 2, 3), c(4, 5, 6))
# Means and Covariance
means_and_covariance(c(1, 2, 3), c(4, 5, 6))
# Correlation Coefficient
correlation_coefficient(c(1, 2, 3), c(4, 5, 6))

## -----------------------------------------------------------------------------
# Absolute Gini Coefficient
absolute_gini_coefficient(c(1, 2, 3, 4, 5))
# Sample Absolute Gini Coefficient
sample_absolute_gini_coefficient(c(1, 2, 3, 4, 5))
# Hoyer Sparsity
hoyer_sparsity(c(1, 0, 0, 2, 3))

noisy_signal <- c(1.1, 2.1, 3.1)
# Oracle SNR
oracle_snr(c(1, 2, 3), c(1.1, 2.1, 3.1))
# Oracle SNR in dB
oracle_snr_db(c(1, 2, 3), c(1.1, 2.1, 3.1))
# M2M4 SNR Estimator in dB
m2m4_snr_estimator(c(1.1, 2.1, 3.1), 3, 2)
# M2M4 SNR Estimator in dB
m2m4_snr_estimator_db(c(1.1, 2.1, 3.1), 3, 2)

## -----------------------------------------------------------------------------
# Anderson-Darling test for normality
anderson_darling_normality_statistic(c(1, 2, 3, 4, 5), 0, 1)

## -----------------------------------------------------------------------------
# One Sample T-Test with parameters
one_sample_t_test_params(sample_mean = 2, sample_variance = 1, num_samples = 30, assumed_mean = 0)
# One Sample T-Test
one_sample_t_test(c(1, 2, 3, 4, 5), assumed_mean = 0)
# Two Sample T-Test
two_sample_t_test(c(1, 2, 3), c(4, 5, 6))
# Paired Samples T-Test
paired_samples_t_test(c(1, 2, 3), c(4, 5, 6))

## -----------------------------------------------------------------------------
# One Sample Z-Test with parameters
one_sample_z_test_params(sample_mean = 2, sample_variance = 1, num_samples = 30, assumed_mean = 0)
# One Sample Z-Test
one_sample_z_test(c(1, 2, 3, 4, 5), assumed_mean = 0)
# Two Sample ZTest
two_sample_z_test(c(1, 2, 3), c(4, 5, 6))

## -----------------------------------------------------------------------------
# Runs Above and Below Threshold
runs_above_and_below_threshold(c(1, 2, 3, 4, 5), threshold = 3)
#' # Runs Above and Below Median
runs_above_and_below_median(c(1, 2, 3, 4, 5))

## -----------------------------------------------------------------------------
# Ljung-Box test for autocorrelation
ljung_box(c(1, 2, 3, 4, 5), lags = 2, fit_dof = 0)

## -----------------------------------------------------------------------------
x <- c(1, 2, 3, 4, 5)
y <- c(2, 3, 5, 7, 11)
# Simple Ordinary Least Squares
simple_ordinary_least_squares(x, y)
# Simple Ordinary Least Squares with R-squared
simple_ordinary_least_squares_with_R_squared(x, y)

