/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.templates.AminoAcids;

public class AminoAcidCountDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private final IAtomContainerSet substructureSet;
    private static String[] names;

    public AminoAcidCountDescriptor() {
        AminoAcid[] aas = AminoAcids.createAAs();
        this.substructureSet = (IAtomContainerSet)aas[0].getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (AminoAcid aa : aas) {
            this.substructureSet.addAtomContainer((IAtomContainer)aa);
        }
        names = new String[this.substructureSet.getAtomContainerCount()];
        for (int i = 0; i < aas.length; ++i) {
            AminoAcidCountDescriptor.names[i] = "n" + aas[i].getProperty((Object)"residueNameShort");
        }
    }

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#aminoAcidsCount", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
    }

    public Object[] getParameters() {
        return null;
    }

    public String[] getDescriptorNames() {
        return names;
    }

    public DescriptorValue calculate(IAtomContainer ac) {
        ac = AminoAcidCountDescriptor.clone((IAtomContainer)ac);
        int resultLength = this.substructureSet.getAtomContainerCount();
        IntegerArrayResult results = new IntegerArrayResult(resultLength);
        UniversalIsomorphismTester universalIsomorphismTester = new UniversalIsomorphismTester();
        for (int i = 0; i < resultLength; ++i) {
            List maps;
            IAtomContainer substructure = this.substructureSet.getAtomContainer(i);
            try {
                maps = universalIsomorphismTester.getSubgraphMaps(ac, substructure);
            }
            catch (CDKException e) {
                for (int j = 0; j < resultLength; ++j) {
                    results.add(0);
                }
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)results, this.getDescriptorNames(), (Exception)((Object)new CDKException("Error in substructure search: " + e.getMessage())));
            }
            if (maps == null) continue;
            results.add(maps.size());
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)results, this.getDescriptorNames());
    }

    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(20);
    }

    public String[] getParameterNames() {
        return new String[0];
    }

    public Object getParameterType(String name) {
        return null;
    }
}

