/*
 * Decompiled with CFR 0.152.
 */
package blogspot.software_and_algorithms.stern_library.geometry;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class ClosestPointPairAlgorithm {
    private List<Point2D> pointsOrderedByXCoordinate;
    private List<Point2D> pointsOrderedByYCoordinate;

    public ClosestPointPairAlgorithm(Collection<Point2D> points) {
        if (points == null) {
            throw new NullPointerException("points is null");
        }
        if (points.size() < 2) {
            throw new IllegalArgumentException("points is too small");
        }
        this.pointsOrderedByXCoordinate = new ArrayList<Point2D>(points);
        Collections.sort(this.pointsOrderedByXCoordinate, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D o1, Point2D o2) {
                double delta = o1.getX() - o2.getX();
                if (delta == 0.0) {
                    delta = o1.getY() - o2.getY();
                }
                return delta < 0.0 ? -1 : (delta > 0.0 ? 1 : 0);
            }
        });
        this.pointsOrderedByYCoordinate = new ArrayList<Point2D>(points);
        Collections.sort(this.pointsOrderedByYCoordinate, new Comparator<Point2D>(){

            @Override
            public int compare(Point2D o1, Point2D o2) {
                double delta = o1.getY() - o2.getY();
                if (delta == 0.0) {
                    delta = o1.getX() - o2.getX();
                }
                return delta < 0.0 ? -1 : (delta > 0.0 ? 1 : 0);
            }
        });
    }

    protected PairStructure closestPair(int low, int high, List<Point2D> localPointsSortedByYCoordinate) {
        int size = high - low;
        if (size == 3) {
            Point2D p1 = this.pointsOrderedByXCoordinate.get(low);
            Point2D p2 = this.pointsOrderedByXCoordinate.get(low + 1);
            Point2D p3 = this.pointsOrderedByXCoordinate.get(low + 2);
            double d1 = p1.distanceSq(p2);
            double d2 = p2.distanceSq(p3);
            double d3 = p1.distanceSq(p3);
            if (d1 < d2) {
                if (d1 < d3) {
                    return new PairStructure(p1, p2, d1);
                }
                return new PairStructure(p1, p3, d3);
            }
            if (d2 < d3) {
                return new PairStructure(p2, p3, d2);
            }
            return new PairStructure(p1, p3, d3);
        }
        if (size == 2) {
            Point2D p1 = this.pointsOrderedByXCoordinate.get(low);
            Point2D p2 = this.pointsOrderedByXCoordinate.get(low + 1);
            return new PairStructure(p1, p2, p1.distanceSq(p2));
        }
        assert (size > 3);
        int mid = low + high >>> 1;
        HashSet<Point2D> leftSubtreeMemberSet = new HashSet<Point2D>(mid - low);
        for (int j = low; j < mid; ++j) {
            leftSubtreeMemberSet.add(this.pointsOrderedByXCoordinate.get(j));
        }
        ArrayList<Point2D> leftPointsOrderedByYCoordinate = new ArrayList<Point2D>(mid - low);
        ArrayList<Point2D> rightPointsOrderedByYCoordinate = new ArrayList<Point2D>(high - mid);
        for (Point2D next : localPointsSortedByYCoordinate) {
            if (leftSubtreeMemberSet.contains(next)) {
                leftPointsOrderedByYCoordinate.add(next);
                continue;
            }
            rightPointsOrderedByYCoordinate.add(next);
        }
        PairStructure leftSubtreeResult = this.closestPair(low, mid, leftPointsOrderedByYCoordinate);
        PairStructure rightSubtreeResult = this.closestPair(mid, high, rightPointsOrderedByYCoordinate);
        PairStructure result = leftSubtreeResult.distanceSq < rightSubtreeResult.distanceSq ? leftSubtreeResult : rightSubtreeResult;
        ArrayList<Point2D> boundaryPointsOrderedByYCoordinate = new ArrayList<Point2D>();
        double midXCoordinate = this.pointsOrderedByXCoordinate.get(mid).getX();
        for (Point2D next : localPointsSortedByYCoordinate) {
            double v = next.getX() - midXCoordinate;
            if (!(v * v < result.distanceSq)) continue;
            boundaryPointsOrderedByYCoordinate.add(next);
        }
        for (int i = 0; i < boundaryPointsOrderedByYCoordinate.size(); ++i) {
            Point2D candidatePartner;
            double v;
            int index;
            Point2D next;
            next = (Point2D)boundaryPointsOrderedByYCoordinate.get(i);
            int j = 1;
            while ((index = i + j) < boundaryPointsOrderedByYCoordinate.size() && !((v = (candidatePartner = (Point2D)boundaryPointsOrderedByYCoordinate.get(index)).getY() - next.getY()) * v >= result.distanceSq)) {
                double candidateDistance = next.distanceSq(candidatePartner);
                if (candidateDistance < result.distanceSq) {
                    result = new PairStructure(next, candidatePartner, candidateDistance);
                }
                ++j;
            }
        }
        return result;
    }

    public Point2D[] execute() {
        PairStructure result = this.closestPair(0, this.pointsOrderedByXCoordinate.size(), this.pointsOrderedByYCoordinate);
        return new Point2D[]{result.p1, result.p2};
    }

    protected static class PairStructure {
        private Point2D p1;
        private Point2D p2;
        private double distanceSq;

        public PairStructure(Point2D point1, Point2D point2, double distanceSq) {
            this.p1 = point1;
            this.p2 = point2;
            this.distanceSq = distanceSq;
        }
    }
}

