/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import org.openscience.cdk.group.AtomContainerDiscretePartitionRefiner;
import org.openscience.cdk.group.AtomDiscretePartitionRefiner;
import org.openscience.cdk.group.BondDiscretePartitionRefiner;

public class PartitionRefinement {
    public static AtomRefinerBuilder forAtoms() {
        return new AtomRefinerBuilder();
    }

    public BondRefinerBuilder forBonds() {
        return new BondRefinerBuilder();
    }

    public static class BondRefinerBuilder {
        private boolean ignoreBondOrders;

        public BondRefinerBuilder ignoringBondOrders() {
            this.ignoreBondOrders = true;
            return this;
        }

        public AtomContainerDiscretePartitionRefiner create() {
            return new BondDiscretePartitionRefiner(this.ignoreBondOrders);
        }
    }

    public static class AtomRefinerBuilder {
        private boolean ignoreAtomTypes;
        private boolean ignoreBondOrders;

        public AtomRefinerBuilder ignoringAtomTypes() {
            this.ignoreAtomTypes = true;
            return this;
        }

        public AtomRefinerBuilder ignoringBondOrders() {
            this.ignoreBondOrders = true;
            return this;
        }

        public AtomContainerDiscretePartitionRefiner create() {
            return new AtomDiscretePartitionRefiner(this.ignoreAtomTypes, this.ignoreBondOrders);
        }
    }
}

