## ----install, eval = FALSE----------------------------------------------------
# #install climodr
# install.packages("climodr")

## ----install dev, eval = FALSE------------------------------------------------
# #install climodr (last a bit, but shouldn't take longer than 5-10 Minutes)
# devtools::install_github(
#   "https://github.com/envima/climodr.git",
#   auth_token = "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",
#   dependencies = TRUE,
#   build_vignettes = TRUE)

## ----setup env----------------------------------------------------------------
library(climodr)

# setting up the environment for climodr
envrmt <- envi.create(tempdir(),
                      memfrac = 0.8)

# load in all the climodr example data for this vignette
clim.sample(envrmt = envrmt)

# remove everything in the global environment except of our environment path list
rm(list = setdiff(ls(), "envrmt"))

## ----prep csv-----------------------------------------------------------------
prep.csv(envrmt = envrmt, 
         method = "proc", 
         save_output = TRUE)

#check the created csv files
csv_files <- grep("_no_NAs.csv$", 
                  list.files(envrmt$path_tworkflow), 
                   value=TRUE)
csv_files

## ----proc csv-----------------------------------------------------------------
csv_data <- proc.csv(envrmt = envrmt, 
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)
head(csv_data)

## ----spat csv-----------------------------------------------------------------
csv_spat <- spat.csv(envrmt = envrmt, 
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)
head(csv_spat)

## ----crop all-----------------------------------------------------------------
crop.all(envrmt = envrmt, 
         method = "MB_Timeseries", 
         overwrite = TRUE)

## ----calc indices-------------------------------------------------------------
calc.indices(envrmt = envrmt, 
             vi = "all",
             bands = c("blue", "green", "red", 
                       "nir", "nirb", 
                       "re1", "re2", "re3", 
                       "swir1", "swir2"),
             overwrite = TRUE)

## ----finalize csv-------------------------------------------------------------
csv_fin <- fin.csv(envrmt = envrmt, 
                   method = "monthly",
                   save_output = TRUE)
head(csv_fin)

## ----autocorr, warning = FALSE------------------------------------------------
autocorr(
  envrmt = envrmt, 
  method = "monthly",
  resp = 5, 
  pred = c(8:23),
  plot.corrplot = TRUE,
  corrplot = "coef"
  )

## ----model, warning = FALSE---------------------------------------------------
calc.model(
  envrmt = envrmt, 
  method = "monthly",
  timespan = c(2017),
  climresp = c(5),
  classifier = c(
    "rf", 
    "pls", 
    "lm"),
  seed = 707,
  p = 0.8,
  folds = "LLO",
  mnote = "vignette",
  predrows = c(8:23),
  tc_method = "cv",
  metric = "RMSE",
  autocorrelation = TRUE,
  doParallel = FALSE)

## ----predict------------------------------------------------------------------
climpred(
  envrmt = envrmt, 
  method = "monthly",
  mnote = "vignette", 
  AOA = TRUE) 

## ----list predictions---------------------------------------------------------
predlist <- list.files(envrmt$path_predictions, 
                       pattern = ".tif", 
                       recursive = TRUE)
head(predlist)

## ----plot predictions---------------------------------------------------------
climplot(
  envrmt = envrmt, 
  mnote = "vignette",
  sensor = "Ta_200",
  aoa = TRUE,
  mapcolors = rev(heat.colors(50)),
  scale_position = "bottomleft",
  north_position = "topright"
)

