/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSPIAuthentication;
import com.microsoft.sqlserver.jdbc.Util;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

final class KerbAuthentication
extends SSPIAuthentication {
    private static final String CONFIGNAME = "SQLJDBCDriver";
    private static final Logger authLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.KerbAuthentication");
    private final SQLServerConnection con;
    private final String spn;
    private final GSSManager manager = GSSManager.getInstance();
    private LoginContext lc = null;
    private GSSCredential peerCredentials = null;
    private GSSContext peerContext = null;

    private void intAuthInit() throws SQLServerException {
        try {
            Object object;
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            Subject subject = null;
            try {
                object = AccessController.getContext();
                subject = Subject.getSubject((AccessControlContext)object);
                if (null == subject) {
                    this.lc = new LoginContext(CONFIGNAME);
                    this.lc.login();
                    subject = this.lc.getSubject();
                }
            }
            catch (LoginException loginException) {
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), loginException);
            }
            object = this.manager.createName(this.spn, null);
            if (authLogger.isLoggable(Level.FINER)) {
                authLogger.finer(this.toString() + " Getting client credentials");
            }
            this.peerCredentials = KerbAuthentication.getClientCredential(subject, this.manager, oid);
            if (authLogger.isLoggable(Level.FINER)) {
                authLogger.finer(this.toString() + " creating security context");
            }
            this.peerContext = this.manager.createContext((GSSName)object, oid, this.peerCredentials, 0);
            this.peerContext.requestCredDeleg(true);
            this.peerContext.requestMutualAuth(true);
            this.peerContext.requestInteg(true);
        }
        catch (GSSException gSSException) {
            authLogger.finer(this.toString() + "initAuthInit failed GSSException:-" + gSSException);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), gSSException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            authLogger.finer(this.toString() + "initAuthInit failed privileged exception:-" + privilegedActionException);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), privilegedActionException);
        }
    }

    private static GSSCredential getClientCredential(Subject subject, final GSSManager gSSManager, final Oid oid) throws PrivilegedActionException {
        PrivilegedExceptionAction<GSSCredential> privilegedExceptionAction = new PrivilegedExceptionAction<GSSCredential>(){

            @Override
            public GSSCredential run() throws GSSException {
                return gSSManager.createCredential(null, 0, oid, 1);
            }
        };
        GSSCredential gSSCredential = Subject.doAs(subject, privilegedExceptionAction);
        return gSSCredential;
    }

    private byte[] intAuthHandShake(byte[] byArray, boolean[] blArray) throws SQLServerException {
        try {
            if (authLogger.isLoggable(Level.FINER)) {
                authLogger.finer(this.toString() + " Sending token to server over secure context");
            }
            byte[] byArray2 = this.peerContext.initSecContext(byArray, 0, byArray.length);
            if (this.peerContext.isEstablished()) {
                blArray[0] = true;
                if (authLogger.isLoggable(Level.FINER)) {
                    authLogger.finer(this.toString() + "Authentication done.");
                }
            } else if (null == byArray2) {
                authLogger.info(this.toString() + "byteToken is null in initSecContext.");
                this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"));
            }
            return byArray2;
        }
        catch (GSSException gSSException) {
            authLogger.finer(this.toString() + "initSecContext Failed :-" + gSSException);
            this.con.terminate(0, SQLServerException.getErrString("R_integratedAuthenticationFailed"), gSSException);
            return null;
        }
    }

    private String makeSpn(String string, int n) throws SQLServerException {
        if (authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + " Server: " + string + " port: " + n);
        }
        StringBuilder stringBuilder = new StringBuilder("MSSQLSvc/");
        stringBuilder.append(string);
        stringBuilder.append(":");
        stringBuilder.append(n);
        String string2 = stringBuilder.toString();
        if (authLogger.isLoggable(Level.FINER)) {
            authLogger.finer(this.toString() + " SPN: " + string2);
        }
        return string2;
    }

    KerbAuthentication(SQLServerConnection sQLServerConnection, String string, int n) throws SQLServerException {
        this.con = sQLServerConnection;
        this.spn = this.makeSpn(string, n);
    }

    @Override
    byte[] GenerateClientContext(byte[] byArray, boolean[] blArray) throws SQLServerException {
        if (null == this.peerContext) {
            this.intAuthInit();
        }
        return this.intAuthHandShake(byArray, blArray);
    }

    @Override
    int ReleaseClientContext() throws SQLServerException {
        try {
            if (null != this.peerCredentials) {
                this.peerCredentials.dispose();
            }
            if (null != this.peerContext) {
                this.peerContext.dispose();
            }
            if (null != this.lc) {
                this.lc.logout();
            }
        }
        catch (LoginException loginException) {
            authLogger.fine(this.toString() + " Release of the credentials failed LoginException: " + loginException);
        }
        catch (GSSException gSSException) {
            authLogger.fine(this.toString() + " Release of the credentials failed GSSException: " + gSSException);
        }
        return 0;
    }

    static {
        class SQLJDBCDriverConfig
        extends Configuration {
            Configuration current = null;
            AppConfigurationEntry[] driverConf;

            SQLJDBCDriverConfig() {
                try {
                    this.current = Configuration.getConfiguration();
                }
                catch (SecurityException securityException) {
                    authLogger.finer(this.toString() + " No configurations provided, setting driver default");
                }
                AppConfigurationEntry[] appConfigurationEntryArray = null;
                if (null != this.current) {
                    appConfigurationEntryArray = this.current.getAppConfigurationEntry(KerbAuthentication.CONFIGNAME);
                }
                if (null == appConfigurationEntryArray) {
                    AppConfigurationEntry appConfigurationEntry;
                    if (authLogger.isLoggable(Level.FINER)) {
                        authLogger.finer(this.toString() + " SQLJDBCDriver configuration entry is not provided, setting driver default");
                    }
                    if (Util.isIBM()) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("useDefaultCcache", "true");
                        hashMap.put("moduleBanner", "false");
                        appConfigurationEntry = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashMap);
                        if (authLogger.isLoggable(Level.FINER)) {
                            authLogger.finer(this.toString() + " Setting IBM Krb5LoginModule");
                        }
                    } else {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("useTicketCache", "true");
                        hashMap.put("doNotPrompt", "true");
                        appConfigurationEntry = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashMap);
                        if (authLogger.isLoggable(Level.FINER)) {
                            authLogger.finer(this.toString() + " Setting Sun Krb5LoginModule");
                        }
                    }
                    this.driverConf = new AppConfigurationEntry[1];
                    this.driverConf[0] = appConfigurationEntry;
                    Configuration.setConfiguration(this);
                }
            }

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
                if (string.equals(KerbAuthentication.CONFIGNAME)) {
                    return this.driverConf;
                }
                if (null != this.current) {
                    return this.current.getAppConfigurationEntry(string);
                }
                return null;
            }

            @Override
            public void refresh() {
                if (null != this.current) {
                    this.current.refresh();
                }
            }
        }
        SQLJDBCDriverConfig sQLJDBCDriverConfig = new SQLJDBCDriverConfig();
    }
}

