/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.datawrapper;

import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.sqlengine.exceptions.SQLEngineException;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.datawrapper.DefaultSqlDataWrapper;
import com.amazon.sqlengine.utilities.SQLEngineMessageKey;
import com.amazon.support.exceptions.ErrorException;
import java.math.BigInteger;

public final class SqlTinyIntDataWrapper
extends DefaultSqlDataWrapper {
    private short m_data;
    private boolean m_isSet = false;
    private boolean m_isNull = false;

    @Override
    public BigInteger getBigInt() throws ErrorException, NullPointerException {
        return BigInteger.valueOf(this.getData());
    }

    @Override
    public double getDouble() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public float getReal() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public long getInteger() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public int getSmallInt() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public short getTinyInt() throws ErrorException, NullPointerException {
        return this.getData();
    }

    @Override
    public int getType() {
        return -6;
    }

    @Override
    public boolean isNull() {
        return this.m_isNull;
    }

    @Override
    public boolean isSet() {
        return this.m_isSet;
    }

    @Override
    public void setBoolean(boolean bl) {
        this.m_isSet = true;
        this.m_isNull = false;
        this.m_data = bl ? (short)1 : 0;
    }

    @Override
    public void setTinyInt(short s) {
        this.m_isSet = true;
        this.m_data = s;
        this.m_isNull = false;
    }

    @Override
    public void setNull() {
        this.m_isSet = true;
        this.m_isNull = true;
    }

    private short getData() throws ErrorException, NullPointerException {
        if (!this.m_isSet) {
            throw SQLEngineExceptionFactory.requestedDataNotSet();
        }
        if (this.m_isNull) {
            throw new NullPointerException("Integer requested, but the data is null.");
        }
        return this.m_data;
    }

    @Override
    public void setValue(DataWrapper dataWrapper) throws ErrorException {
        if (dataWrapper.isNull()) {
            this.setNull();
        } else {
            try {
                switch (dataWrapper.getType()) {
                    case 16: {
                        this.setBoolean(dataWrapper.getBoolean());
                        break;
                    }
                    case -7: {
                        this.setBoolean(dataWrapper.getBit());
                        break;
                    }
                    case -6: {
                        this.setTinyInt(dataWrapper.getTinyInt());
                        break;
                    }
                    default: {
                        throw SQLEngineExceptionFactory.invalidSqlTypeForWrapperException(dataWrapper.getType());
                    }
                }
            }
            catch (IncorrectTypeException incorrectTypeException) {
                throw new SQLEngineException(SQLEngineMessageKey.INVALID_OPERATION.name(), incorrectTypeException);
            }
        }
    }

    @Override
    public void retrieveData(DataWrapper dataWrapper) throws ErrorException {
        if (!this.m_isSet) {
            throw new IllegalStateException("ISqlDataWrapper is not set with data for retrieval");
        }
        if (this.m_isNull) {
            dataWrapper.setNull(-6);
            return;
        }
        dataWrapper.setTinyInt(this.m_data);
    }
}

