/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.dataengine.metadata;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.dataengine.interfaces.IMetadataSource;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.redshift.client.PGMessagingContext;
import com.amazon.redshift.core.PGArray;
import com.amazon.redshift.dataengine.PGResultSet;
import com.amazon.support.ILogger;
import com.amazon.support.LogUtilities;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import java.util.ArrayList;
import java.util.List;

public class PGTablePrivilegesMetadatSourceFromQuery
extends PGResultSet
implements IMetadataSource {
    private List<GranteePrivileges> m_tablePrivileges;
    private GranteePrivileges m_currentGrantee;
    private int m_granteeIndex;
    private int m_granteesNumber = 1;
    private int m_privilegeIndex;
    private int m_privilegesNumber = 1;

    public PGTablePrivilegesMetadatSourceFromQuery(PGMessagingContext pGMessagingContext, ILogger iLogger) {
        super(pGMessagingContext, iLogger);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return super.getData(0, l, l2, dataWrapper);
            }
            case SCHEMA_NAME: {
                return super.getData(1, l, l2, dataWrapper);
            }
            case TABLE_NAME: {
                return super.getData(2, l, l2, dataWrapper);
            }
            case GRANTOR: {
                if (null != this.m_currentGrantee) {
                    dataWrapper.setVarChar(this.m_currentGrantee.m_grantor);
                } else {
                    dataWrapper.setVarChar("toto");
                }
                return false;
            }
            case GRANTEE: {
                if (null != this.m_currentGrantee) {
                    dataWrapper.setVarChar(this.m_currentGrantee.m_grantee);
                } else {
                    dataWrapper.setVarChar("tutu");
                }
                return false;
            }
            case PRIVILEGE: {
                if (null != this.m_currentGrantee) {
                    dataWrapper.setVarChar(this.m_currentGrantee.m_privileges.get(this.m_privilegeIndex));
                } else {
                    dataWrapper.setVarChar("pouet");
                }
                return false;
            }
            case ISGRANTABLE: {
                dataWrapper.setNull(12);
                return false;
            }
        }
        throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_COLNUM.name(), new String[]{metadataSourceColumnTag.toString()}, ExceptionType.DEFAULT);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean moveToNextRow() {
        boolean bl = false;
        try {
            if (this.m_granteeIndex == this.m_granteesNumber - 1 && this.m_privilegeIndex == this.m_privilegesNumber - 1) {
                this.m_privilegeIndex = 0;
                this.m_privilegesNumber = 1;
                this.m_granteeIndex = 0;
                this.m_granteesNumber = 1;
                bl = super.moveToNextRow();
                if (true != bl) return bl;
                DataWrapper dataWrapper = new DataWrapper();
                super.getData(4, 0L, -1L, dataWrapper);
                PGArray pGArray = (PGArray)dataWrapper.getArray();
                this.m_tablePrivileges = new ArrayList<GranteePrivileges>();
                GranteePrivileges granteePrivileges = null;
                if (null != pGArray) {
                    String[] stringArray;
                    String string = pGArray.getStringRepresentation();
                    string = string.substring(1, string.length() - 1);
                    for (String string2 : stringArray = string.split(",")) {
                        String string3 = string2.substring(0, string2.indexOf("="));
                        String string4 = string2.substring(string2.indexOf("/") + 1, string2.length());
                        String string5 = string2.substring(string2.indexOf("=") + 1, string2.indexOf("/"));
                        granteePrivileges = new GranteePrivileges(string3, string4, string5);
                        this.m_tablePrivileges.add(granteePrivileges);
                    }
                } else {
                    dataWrapper = new DataWrapper();
                    super.getData(3, 0L, -1L, dataWrapper);
                    String string = dataWrapper.getVarChar();
                    granteePrivileges = new GranteePrivileges(string);
                    this.m_tablePrivileges.add(granteePrivileges);
                }
                this.m_granteesNumber = this.m_tablePrivileges.size();
                this.m_currentGrantee = this.m_tablePrivileges.get(this.m_granteeIndex);
                this.m_privilegesNumber = this.m_currentGrantee.m_privileges.size();
                return true;
            }
            if (this.m_privilegeIndex != this.m_privilegesNumber - 1) {
                ++this.m_privilegeIndex;
                return true;
            } else {
                ++this.m_granteeIndex;
                this.m_currentGrantee = this.m_tablePrivileges.get(this.m_granteeIndex);
                this.m_privilegeIndex = 0;
                this.m_privilegesNumber = this.m_currentGrantee.m_privileges.size();
            }
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private class GranteePrivileges {
        private static final String UNSET_GRANTEE = "PUBLIC";
        private static final String UNKNOWN = "UNKNOWN";
        public List<String> m_privileges;
        public String m_grantee;
        public String m_grantor;

        private GranteePrivileges(String string, String string2, String string3) {
            this.m_grantee = string;
            if (0 == string.length()) {
                this.m_grantee = UNSET_GRANTEE;
            }
            this.m_grantor = string2;
            this.m_privileges = new ArrayList<String>();
            for (char c : string3.toCharArray()) {
                Privilege privilege = Privilege.getPrivilegeFromId(c);
                if (null == privilege) continue;
                this.m_privileges.add(privilege.toString());
            }
            if (this.m_grantee.equals(UNSET_GRANTEE) && this.m_privileges.contains(Privilege.SELECT.toString())) {
                this.m_privileges.add(Privilege.DELETE.toString());
            }
            this.m_privileges.add(UNKNOWN);
        }

        private GranteePrivileges(String string) {
            this.m_grantee = string;
            this.m_grantor = string;
            this.m_privileges = new ArrayList<String>();
            for (Privilege privilege : Privilege.values()) {
                this.m_privileges.add(privilege.toString());
            }
        }
    }

    private static enum Privilege {
        SELECT('r'),
        UPDATE('w'),
        INSERT('a'),
        DELETE('d'),
        RULE('R'),
        REFERENCES('x'),
        TRIGGER('t');

        private char m_id;

        private Privilege(char c) {
            this.m_id = c;
        }

        public static Privilege getPrivilegeFromId(char c) {
            for (Privilege privilege : Privilege.values()) {
                if (privilege.m_id != c) continue;
                return privilege;
            }
            return null;
        }
    }
}

