/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.client.messages.outbound;

import com.amazon.jdbc.communications.interfaces.AbstractOutboundMessage;
import com.amazon.redshift.client.PGConstants;
import com.amazon.redshift.core.IPGLogger;
import java.nio.ByteBuffer;

public class Bind
extends AbstractOutboundMessage
implements PGConstants {
    private final byte[] m_portalName;
    private final byte[] m_preparedStatementName;
    private final short[] m_formatCodes;
    private final byte[][] m_parameterValues;
    private final short[] m_resultColumnFormatCodes;

    public Bind(byte[] byArray, byte[] byArray2, short[] sArray, byte[][] byArray3, short[] sArray2, IPGLogger iPGLogger) {
        this.m_portalName = byArray;
        this.m_preparedStatementName = byArray2;
        this.m_formatCodes = sArray;
        this.m_parameterValues = byArray3;
        this.m_resultColumnFormatCodes = sArray2;
        if (iPGLogger.isExternalLoggerEnabled()) {
            this.logMessageContent(iPGLogger);
        }
    }

    @Override
    public void serialize(ByteBuffer byteBuffer, byte[] byArray) {
        byteBuffer.put((byte)66);
        byteBuffer.put(byArray);
        if (null != this.m_portalName) {
            byteBuffer.put(this.m_portalName);
        }
        byteBuffer.put(TERMINATOR);
        if (null != this.m_preparedStatementName) {
            byteBuffer.put(this.m_preparedStatementName);
        }
        byteBuffer.put(TERMINATOR);
        if (null != this.m_formatCodes) {
            byteBuffer.putShort((short)this.m_formatCodes.length);
            for (short s : this.m_formatCodes) {
                byteBuffer.putShort(s);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
        if (null != this.m_parameterValues) {
            byteBuffer.putShort((short)this.m_parameterValues.length);
            for (byte[] byArray2 : this.m_parameterValues) {
                if (null != byArray2) {
                    byteBuffer.putInt(byArray2.length);
                    byteBuffer.put(byArray2);
                    continue;
                }
                byteBuffer.putInt(-1);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
        if (null != this.m_resultColumnFormatCodes) {
            byteBuffer.putShort((short)this.m_resultColumnFormatCodes.length);
            for (short s : this.m_resultColumnFormatCodes) {
                byteBuffer.putShort(s);
            }
        } else {
            byteBuffer.putShort((short)0);
        }
    }

    @Override
    public int getSize() {
        int n = 4 + (this.m_portalName != null ? this.m_portalName.length : 0) + 1 + (this.m_preparedStatementName != null ? this.m_preparedStatementName.length : 0) + 1 + 2 + (this.m_formatCodes != null ? this.m_formatCodes.length * 2 : 0) + 2;
        if (null != this.m_parameterValues) {
            n += 4 * this.m_parameterValues.length;
            for (byte[] byArray : this.m_parameterValues) {
                if (null == byArray) continue;
                n += byArray.length;
            }
        }
        return n += 2 + (this.m_resultColumnFormatCodes != null ? this.m_resultColumnFormatCodes.length * 2 : 0);
    }

    public void logMessageContent(IPGLogger iPGLogger) {
        String string = null;
        if (null != this.m_preparedStatementName) {
            string = new String(this.m_preparedStatementName);
        }
        String string2 = null;
        if (null != this.m_portalName) {
            string2 = new String(this.m_portalName);
        }
        String string3 = "=>FE Bind(stmt=" + string + ",portal=" + string2 + ")";
        iPGLogger.logDebugExternal(string3);
    }
}

