/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.impl.DSIDriver;
import com.amazon.dsi.core.impl.DSIDriverSingleton;
import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.amazon.dsi.dataengine.interfaces.IArray;
import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.dsi.dataengine.interfaces.IDataEngine;
import com.amazon.dsi.dataengine.interfaces.IErrorResult;
import com.amazon.dsi.dataengine.interfaces.IResultSet;
import com.amazon.dsi.dataengine.interfaces.IResults;
import com.amazon.dsi.dataengine.interfaces.IRowCountResult;
import com.amazon.dsi.dataengine.interfaces.IStreamQueryExecutor;
import com.amazon.dsi.dataengine.utilities.ColumnMetadata;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ExecutionContexts;
import com.amazon.dsi.dataengine.utilities.ExecutionResult;
import com.amazon.dsi.dataengine.utilities.ExecutionResultType;
import com.amazon.dsi.dataengine.utilities.Nullable;
import com.amazon.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.amazon.dsi.dataengine.utilities.ParameterInputValue;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.dsi.dataengine.utilities.ParameterType;
import com.amazon.dsi.dataengine.utilities.TimeTz;
import com.amazon.dsi.dataengine.utilities.TimestampTz;
import com.amazon.dsi.dataengine.utilities.TypeMetadata;
import com.amazon.dsi.dataengine.utilities.TypeUtilities;
import com.amazon.dsi.exceptions.BadDefaultParamException;
import com.amazon.dsi.exceptions.IncorrectTypeException;
import com.amazon.dsi.exceptions.InputOutputException;
import com.amazon.dsi.utilities.DSIMessageKey;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SArray;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SForwardResultSet;
import com.amazon.jdbc.common.SParameterMetaData;
import com.amazon.jdbc.common.SResultSetMetaData;
import com.amazon.jdbc.common.SStatement;
import com.amazon.streams.parameters.AbstractParameterStream;
import com.amazon.streams.parameters.AsciiParameterStream;
import com.amazon.streams.parameters.BinaryParameterStream;
import com.amazon.streams.parameters.CharacterParameterStream;
import com.amazon.streams.parameters.UnicodeParameterStream;
import com.amazon.support.IWarningListener;
import com.amazon.support.LogUtilities;
import com.amazon.support.Pair;
import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.ExactNumConverter;
import com.amazon.support.exceptions.ErrorException;
import com.amazon.support.exceptions.ExceptionType;
import com.amazon.utilities.FunctionID;
import com.amazon.utilities.ReferenceEqualityWrapper;
import com.amazon.utilities.conversion.TypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class SPreparedStatement
extends SStatement
implements PreparedStatement {
    private static final Map<Integer, Set<Integer>> s_stringRepCompatibilityLookup = SPreparedStatement.initializeStringRepCompatibilityLookup();
    protected ArrayList<ParameterMetadata> m_parameterMetadata;
    protected final int m_numParameters;
    protected List<ParameterType> m_parameterTypes;
    protected Map<Integer, DataWrapper> m_parameterInputValues = new TreeMap<Integer, DataWrapper>();
    protected Map<Integer, AbstractParameterStream> m_parameterInputStreamData = new TreeMap<Integer, AbstractParameterStream>();
    protected boolean m_hasParameterBatch = false;
    protected List<Map<Integer, DataWrapper>> m_batchParameterInputValues = new ArrayList<Map<Integer, DataWrapper>>();
    protected List<Map<Integer, AbstractParameterStream>> m_batchParameterInputStreamData = new ArrayList<Map<Integer, AbstractParameterStream>>();
    private final List<Pair<Integer, SQLException>> m_batchParamConversionExceptions = new ArrayList<Pair<Integer, SQLException>>();
    private int m_numSuccessfulBatches = 0;
    protected String m_preparedSql = "";
    protected SResultSetMetaData m_metadata = null;
    protected SParameterMetaData m_openParamMetaData = null;
    private List<DataWrapper> m_cachedDataWrappers = null;
    private boolean m_supportStreamingBatches = false;
    private HashSet<ReferenceEqualityWrapper> m_currExecutionStreamSet = new HashSet();
    private HashSet<ReferenceEqualityWrapper> m_lastStreamsExecuted = new HashSet();
    private int m_nextParamSetForStream = 0;
    protected HashMap<Integer, TypeMetadata> m_setMetadata;
    protected boolean m_isSetMetadataFinal = false;
    private final int UNKNOWN_TYPE = 2000;

    protected SPreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(iStatement, sConnection, n);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, iStatement, sConnection);
            this.m_preparedSql = string;
            this.checkIfNullSQL(string);
            IDataEngine iDataEngine = this.m_statement.createDataEngine();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                string = sConnection.nativeSQL(string);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.replaceQueryExecutor(iDataEngine, iDataEngine.prepare(string));
            this.m_parameterMetadata = this.m_queryExecutor.getMetadataForParameters();
            if (null == this.m_parameterMetadata) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_PARAM_METADATA, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_numParameters = this.m_parameterMetadata.size();
            this.m_setMetadata = new HashMap();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>(this.m_numParameters);
            this.m_parameterTypes = new ArrayList<ParameterType>(this.m_numParameters);
            boolean bl = true;
            for (int i = 0; i < this.m_numParameters; ++i) {
                ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(i);
                if (bl && parameterMetadata.getTypeMetadata().isCharacterOrBinaryType()) {
                    bl = false;
                    this.m_parentConnection.setMaxTypeValues();
                }
                this.m_parameterTypes.add(parameterMetadata.getParameterType());
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
            this.checkParameters(this.m_parameterMetadata);
            this.clearParameters();
            if (this.m_parentConnection.getConnection().getProperty(1006).getString().equals("Y")) {
                if (!(this.m_queryExecutor instanceof IStreamQueryExecutor)) {
                    this.getLogger().logWarning("com.amazon.jdbc.common", "SPreparedStatement", "SPreparedStatement", "ConnPropertyKey.DSI_SUPPORTS_STREAMED_BATCH_PREPARED_STMTS is set to 'Y', but IStreamQueryExecutor interface is not implemented. Batched parameters will not be streamed.");
                } else {
                    this.m_supportStreamingBatches = true;
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        block9: {
            try {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
                this.checkIfOpen();
                this.m_queryExecutor.clearCancel();
                if (!this.allInputParameterValuesPopulated()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                this.updateParameterMetadata();
                this.m_cachedDataWrappers.clear();
                for (int i = 0; i < this.m_numParameters; ++i) {
                    this.m_cachedDataWrappers.add(new DataWrapper());
                }
                this.m_hasParameterBatch = true;
                if (!this.m_supportStreamingBatches) {
                    this.m_batchParameterInputValues.add(this.m_parameterInputValues);
                    this.m_batchParameterInputStreamData.add(this.m_parameterInputStreamData);
                    this.m_parameterInputValues = new TreeMap<Integer, DataWrapper>(this.m_parameterInputValues);
                    this.m_parameterInputStreamData = new TreeMap<Integer, AbstractParameterStream>();
                    break block9;
                }
                IStreamQueryExecutor iStreamQueryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                if (0 == this.m_nextParamSetForStream) {
                    this.m_batchParamConversionExceptions.clear();
                    this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                    this.m_parentConnection.beginTransaction();
                    this.clearResults();
                    ++this.m_nextParamSetForStream;
                }
                ArrayList<ParameterInputValue> arrayList = null;
                try {
                    arrayList = this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreamData);
                }
                catch (SQLException sQLException) {
                    this.m_batchParamConversionExceptions.add(new Pair<Integer, SQLException>(this.m_numSuccessfulBatches, sQLException));
                    this.m_numSuccessfulBatches = 0;
                }
                if (arrayList != null) {
                    iStreamQueryExecutor.startParamSet(arrayList, this.m_warningListener);
                    this.pushClearSingleBatchSetStreams();
                    iStreamQueryExecutor.finalizeParamSet(this.m_warningListener);
                    ++this.m_numSuccessfulBatches;
                }
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        this.doClearBatch();
    }

    private void doClearBatch() throws SQLException {
        try {
            this.m_isSetMetadataFinal = false;
            this.m_setMetadata.clear();
            for (int i = 0; i < this.m_batchParameterInputValues.size(); ++i) {
                this.clearParameters(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreamData.get(i));
            }
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreamData);
            if (null != this.m_queryExecutor) {
                if (this.m_supportStreamingBatches) {
                    IStreamQueryExecutor iStreamQueryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                    this.m_nextParamSetForStream = 0;
                    this.m_numSuccessfulBatches = 0;
                    iStreamQueryExecutor.clearBatch();
                } else {
                    this.m_queryExecutor.clearPushedParamData();
                    this.m_batchParameterInputStreamData.clear();
                    this.m_batchParameterInputValues.clear();
                }
            }
            this.m_hasParameterBatch = false;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_isSetMetadataFinal = false;
            this.m_setMetadata.clear();
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreamData);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.doClearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
        if (null != this.m_queryExecutor) {
            this.m_queryExecutor.close();
            this.m_queryExecutor = null;
        }
        if (null != this.m_metadata) {
            this.m_metadata = null;
        }
        if (null != this.m_openParamMetaData) {
            this.m_openParamMetaData.close();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            boolean bl;
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.updateParameterMetadata();
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            IResults iResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), this.m_generatedParams, SStatement.ThrowCondition.None);
            this.m_resultIterator = iResults.getResultItr();
            if (!this.m_resultIterator.hasNext()) {
                boolean bl2 = false;
                return bl2;
            }
            ExecutionResult executionResult = this.moveToNextResult();
            this.addResultPair(this.createResultPair(executionResult));
            SStatement.ResultContext resultContext = (SStatement.ResultContext)this.m_resultSets.get(0);
            if (ExecutionResultType.ERROR_RESULT_SET == resultContext.m_resultType || ExecutionResultType.ERROR_ROW_COUNT == resultContext.m_resultType) {
                throw ((IErrorResult)resultContext.m_result).getError();
            }
            boolean bl3 = bl = ExecutionResultType.RESULT_SET == resultContext.m_resultType;
            if (bl) {
                this.setResultSetMetadata(this.createResultSetMetaData((IResultSet)executionResult.getResult()));
            }
            boolean bl4 = bl;
            return bl4;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        finally {
            this.m_isSetMetadataFinal = false;
        }
    }

    @Override
    public synchronized boolean execute(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        this.m_numSuccessfulBatches = 0;
        try {
            BatchExecResult batchExecResult = this.executePreparedAnyBatch();
            switch (batchExecResult) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new int[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processBatchResults(this.m_queryExecutor.getResults(), this.m_batchParamConversionExceptions, SStatement.BatchType.MULTI_PARAM_SET);
                }
                case BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION: {
                    return this.processBatchResults(null, this.m_batchParamConversionExceptions, SStatement.BatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + batchExecResult.name());
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    private ExecutionContexts createExecutionContextsForBatchExec() {
        int n = this.m_batchParameterInputValues.size();
        ArrayList<ArrayList<ParameterInputValue>> arrayList = new ArrayList<ArrayList<ParameterInputValue>>(n);
        this.m_batchParamConversionExceptions.clear();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                arrayList.add(this.getInputParameterValues(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreamData.get(i)));
                ++n2;
                continue;
            }
            catch (SQLException sQLException) {
                this.m_batchParamConversionExceptions.add(new Pair<Integer, SQLException>(n2, sQLException));
                n2 = 0;
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return new ExecutionContexts(this.m_parameterMetadata, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized BatchExecResult executePreparedAnyBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.m_queryExecutor.clearCancel();
            if (!this.m_supportStreamingBatches) {
                this.m_parentConnection.beginTransaction();
                this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                this.clearResults();
                if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                    this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                    object = BatchExecResult.BATCH_EXEC_NO_BATCHES;
                    return object;
                }
                this.pushBatchParameterStreams();
                ExecutionContexts executionContexts = this.createExecutionContextsForBatchExec();
                if (executionContexts == null) {
                    object = BatchExecResult.BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION;
                    return object;
                }
                object = this.m_cancelLock;
                synchronized (object) {
                    if (this.m_isCanceled) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                }
                this.m_queryExecutor.execute(executionContexts, this.m_warningListener);
            } else {
                this.m_currExecutionStreamSet.clear();
                this.m_queryExecutor.finalizePushedParamData();
                object = (IStreamQueryExecutor)this.m_queryExecutor;
                if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                    this.clearResults();
                    this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                    BatchExecResult batchExecResult = BatchExecResult.BATCH_EXEC_NO_BATCHES;
                    return batchExecResult;
                }
                Object object2 = this.m_cancelLock;
                synchronized (object2) {
                    if (this.m_isCanceled) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                }
                object.execute(this.m_warningListener);
            }
            object = BatchExecResult.BATCH_EXEC_SUCCEEDED;
            return object;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
            this.clearBatch();
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.updateParameterMetadata();
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            long l = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            boolean bl = 0L != (l & 1L);
            IResults iResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), this.m_generatedParams, bl ? SStatement.ThrowCondition.None : SStatement.ThrowCondition.SingleResult);
            this.m_resultIterator = iResults.getResultItr();
            ExecutionResult executionResult = this.checkAndMoveToNextResult(this.m_preparedSql, iResults, bl ? SStatement.ThrowCondition.SingleResult : SStatement.ThrowCondition.None);
            if (ExecutionResultType.ERROR_RESULT_SET == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            this.setResultSetMetadata(this.createResultSetMetaData((IResultSet)executionResult.getResult()));
            ResultSet resultSet = this.createResultSet(executionResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        finally {
            this.m_isSetMetadataFinal = false;
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    public synchronized int executeAnyUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.updateParameterMetadata();
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            long l = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            boolean bl = 0L != (l & 1L);
            IResults iResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), this.m_generatedParams, bl ? SStatement.ThrowCondition.None : SStatement.ThrowCondition.SingleRowCount);
            this.m_resultIterator = iResults.getResultItr();
            ExecutionResult executionResult = this.checkAndMoveToNextResult(this.m_preparedSql, iResults, bl ? SStatement.ThrowCondition.SingleRowCount : SStatement.ThrowCondition.None);
            if (ExecutionResultType.ERROR_ROW_COUNT == executionResult.getType()) {
                this.addResultPair(this.createResultPair(executionResult));
                throw ((IErrorResult)executionResult.getResult()).getError();
            }
            IRowCountResult iRowCountResult = (IRowCountResult)executionResult.getResult();
            this.addResultPair(this.createResultPair(executionResult));
            if (iRowCountResult.hasRowCount()) {
                long l2 = iRowCountResult.getRowCount();
                int n = l2 > Integer.MAX_VALUE ? -2 : (int)l2;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
        finally {
            this.m_isSetMetadataFinal = false;
        }
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, n);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, nArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, string, stringArray);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public SResultSetMetaData getResultSetMetaData() {
        return this.m_metadata;
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @Override
    public synchronized void setArray(int n, Array array) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, array);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            SArray sArray = (SArray)array;
            if (null == array) {
                this.setNull(n, 2003);
            } else {
                IArray iArray = sArray.getDSIArray();
                TypeMetadata typeMetadata = TypeUtilities.getNestedMetadata(iArray);
                Object[] objectArray = TypeConverter.convertToObjectArray(array.getArray());
                IConnection iConnection = this.getParentConnection().getConnection();
                String string = typeMetadata.getTypeName();
                IArray iArray2 = iConnection.createArrayOf(string, objectArray);
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setArray(iArray2);
                this.setParameterInputData(n, dataWrapper);
                if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                    TypeMetadata typeMetadata2 = TypeMetadata.createTypeMetadata(2003);
                    TypeMetadata typeMetadata3 = iArray2.getBaseColumn().getTypeMetadata();
                    ArrayList<IColumn> arrayList = new ArrayList<IColumn>();
                    ColumnMetadata columnMetadata = new ColumnMetadata(typeMetadata3);
                    arrayList.add(columnMetadata);
                    typeMetadata2.setNestedColumnList(arrayList);
                    this.m_setMetadata.put(n - 1, typeMetadata2);
                }
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == inputStream) {
                this.setNull(n, this.m_setMetadata.get(n - 1).getType());
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, n2);
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bigDecimal);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            TypeMetadata typeMetadata = this.createExactNumMetadata(bigDecimal, 2);
            if (null == bigDecimal) {
                this.setNull(n, 2);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setNumeric(bigDecimal);
                this.setParameterInputData(n, dataWrapper);
            }
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, typeMetadata);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -4)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            }
            if (null == inputStream) {
                this.setNull(n, -4);
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, n2);
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, blob);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, bl);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(16));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setBoolean(bl);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setByte(int n, byte by) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, by);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-6, true));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setTinyInt(by);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, byArray);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            int n2 = null == byArray || byArray.length <= this.m_parentConnection.m_maxVarcharSize ? -3 : -4;
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(n2));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == byArray) {
                dataWrapper.setNull(n2);
            } else if (n2 == -4) {
                dataWrapper.setLongVarBinary(byArray);
            } else {
                dataWrapper.setVarBinary(byArray);
            }
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, reader, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == reader) {
                this.setNull(n, -1);
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, (long)n2);
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setClob(int n, Clob clob) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clob);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int n, Date date) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, date);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(91));
            }
            if (null == date) {
                this.setNull(n, 91);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setDate(date);
                this.setParameterInputData(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, date);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        try {
            if (null == calendar || null == date) {
                this.setDate(n, date);
            } else {
                calendar.clear();
                calendar.setTimeInMillis(date.getTime());
                Calendar calendar2 = Calendar.getInstance();
                calendar2.clear();
                calendar2.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                calendar2.set(14, 0);
                this.setDate(n, new Date(calendar2.getTimeInMillis()));
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDouble(int n, double d) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, d);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(8));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setDouble(d);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFloat(int n, float f) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, Float.valueOf(f));
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(7));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setReal(f);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setInt(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(4, true));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setInteger(n2);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLong(int n, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-5, true));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setBigInt(BigInteger.valueOf(l));
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int n, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            this.checkTypeSupported(n2);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, this.createMetadataForSqlType(n2));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setNull(n2);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, n2, string);
        this.setNull(n, n2);
    }

    @Override
    public synchronized void setObject(int n, Object object) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == object) {
                dataWrapper.setNull(2000);
            } else {
                int n2 = TypeConverter.getSqlType(object);
                dataWrapper.setData(n2, object);
                if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                    TypeMetadata typeMetadata = object instanceof BigDecimal && (2 == n2 || 3 == n2) ? this.createExactNumMetadata((BigDecimal)object, n2) : this.createMetadataForSqlType(n2);
                    this.m_setMetadata.put(n - 1, typeMetadata);
                }
            }
            this.setParameterInputData(n, dataWrapper);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(object));
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, n2);
            int n3 = 0;
            if (object instanceof BigDecimal) {
                n3 = this.createExactNumMetadata((BigDecimal)object, 2).getScale();
            }
            this.setObject(n, object, n2, n3);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        block11: {
            try {
                LogUtilities.logFunctionEntrance(this.getLogger(), n, object, n2, n3);
                this.checkIfOpen();
                this.checkValidParameterIndex(n);
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                if (null == object) {
                    this.setNull(n, n2);
                    break block11;
                }
                try {
                    int n4 = TypeConverter.getSqlType(object);
                    dataWrapper.setData(n4, object);
                    if (n2 != n4) {
                        dataWrapper = object instanceof BigDecimal && (2 == n2 || 3 == n2) ? TypeConverter.toType(dataWrapper, this.createExactNumMetadata((BigDecimal)object, n2), (IWarningListener)this.getWarningListener()) : TypeConverter.toType(dataWrapper, object, n2, this.getWarningListener());
                    }
                    TypeMetadata typeMetadata = null;
                    switch (n2) {
                        case 2: {
                            BigDecimal bigDecimal = dataWrapper.getNumeric().setScale(n3, 4);
                            typeMetadata = this.createExactNumMetadata(bigDecimal, n2);
                            dataWrapper.setNumeric(bigDecimal);
                            break;
                        }
                        case 3: {
                            BigDecimal bigDecimal = dataWrapper.getDecimal().setScale(n3, 4);
                            typeMetadata = this.createExactNumMetadata(bigDecimal, n2);
                            dataWrapper.setDecimal(bigDecimal);
                            break;
                        }
                        default: {
                            typeMetadata = this.createMetadataForSqlType(n2);
                        }
                    }
                    if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                        this.m_setMetadata.put(n - 1, typeMetadata);
                    }
                }
                catch (IncorrectTypeException incorrectTypeException) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(object));
                }
                this.setParameterInputData(n, dataWrapper);
            }
            catch (Exception exception) {
                throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
            }
        }
    }

    public void setParameterInputStream(int n, AbstractParameterStream abstractParameterStream) throws SQLException {
        ParameterMetadata parameterMetadata = this.m_parameterMetadata.get(n - 1);
        if (ParameterType.OUTPUT == parameterMetadata.getParameterType()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SET_TYPE, (IWarningListener)this.getWarningListener(), ExceptionType.DATA, String.valueOf(n));
        }
        this.m_parameterInputValues.remove(n);
        AbstractParameterStream abstractParameterStream2 = this.m_parameterInputStreamData.get(n);
        if (null != abstractParameterStream2) {
            this.m_lastStreamsExecuted.remove(abstractParameterStream2.getEqualityStreamWrapper());
            abstractParameterStream2.close();
        }
        this.m_parameterInputStreamData.put(n, abstractParameterStream);
    }

    public void setResultSetMetadata(SResultSetMetaData sResultSetMetaData) {
        this.m_metadata = sResultSetMetaData;
    }

    @Override
    public synchronized void setRef(int n, Ref ref) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, ref);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setShort(int n, short s) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, s);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(5, true));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            dataWrapper.setSmallInt(s);
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setString(int n, String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, string);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            int n2 = null == string || string.length() <= this.m_parentConnection.m_maxVarcharSize ? 12 : -1;
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(n2));
            }
            DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
            if (null == string) {
                dataWrapper.setNull(12);
            } else if (-1 == n2) {
                dataWrapper.setLongVarChar(string);
            } else {
                dataWrapper.setVarChar(string);
            }
            this.setParameterInputData(n, dataWrapper);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int n, Time time) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, this.createTimeMetadata());
            }
            if (null == time) {
                this.setNull(n, 92);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTime(time);
                this.setParameterInputData(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, time);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, this.createTimeMetadata());
            }
            if (null == time) {
                this.setNull(n, 92);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTime(new TimeTz(time, calendar));
                this.setParameterInputData(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, this.createTimestampMetadata());
            }
            if (null == timestamp) {
                this.setNull(n, 93);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTimestamp(timestamp);
                this.setParameterInputData(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, timestamp, calendar);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, this.createTimestampMetadata());
            }
            if (null == timestamp) {
                this.setNull(n, 93);
            } else {
                DataWrapper dataWrapper = this.m_cachedDataWrappers.get(n - 1);
                dataWrapper.setTimestamp(new TimestampTz(timestamp, calendar));
                this.setParameterInputData(n, dataWrapper);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, inputStream, n2);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == inputStream) {
                this.setNull(n, -1);
            } else {
                UnicodeParameterStream unicodeParameterStream = new UnicodeParameterStream(inputStream, n2);
                this.setParameterInputStream(n, unicodeParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setURL(int n, URL uRL) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, n, uRL);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setAsciiStream(n, inputStream, -1);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == inputStream) {
                this.setNull(n, -1);
            } else {
                AsciiParameterStream asciiParameterStream = new AsciiParameterStream(inputStream, l);
                this.setParameterInputStream(n, asciiParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        this.setBinaryStream(n, inputStream, -1);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -4)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-4));
            }
            if (null == inputStream) {
                this.setNull(n, -4);
            } else {
                BinaryParameterStream binaryParameterStream = new BinaryParameterStream(inputStream, l);
                this.setParameterInputStream(n, binaryParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, inputStream, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.setCharacterStream(n, reader, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(n - 1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(n - 1).getType(), -1)) {
                this.m_setMetadata.put(n - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == reader) {
                this.setNull(n, -1);
            } else {
                CharacterParameterStream characterParameterStream = new CharacterParameterStream(reader, l);
                this.setParameterInputStream(n, characterParameterStream);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, nClob);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, reader, l);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, string);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, rowId);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), n, sQLXML);
        this.checkIfOpen();
        this.checkValidParameterIndex(n);
        SQLException sQLException = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(sQLException, this.getLogger());
        throw sQLException;
    }

    @Override
    void closeIfPrepared() throws SQLException {
        this.close();
    }

    protected boolean allInputParameterValuesPopulated() {
        return this.m_parameterInputStreamData.size() + this.m_parameterInputValues.size() == this.m_numParameters;
    }

    protected void checkParameters(List<ParameterMetadata> list) throws SQLException {
        for (int i = 0; i < list.size(); ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INPUT_ONLY, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(list.get(i).getParameterNumber()));
        }
    }

    protected void checkTypeSupported(int n) throws SQLException {
        switch (n) {
            case -11: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2003: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        }
    }

    protected void checkValidParameterIndex(int n) throws SQLException {
        if (1 > n || this.m_numParameters < n) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
    }

    protected void clearParameters(Map<Integer, DataWrapper> map, Map<Integer, AbstractParameterStream> map2) {
        map.clear();
        for (AbstractParameterStream abstractParameterStream : map2.values()) {
            if (null == abstractParameterStream) continue;
            this.m_lastStreamsExecuted.remove(abstractParameterStream.getEqualityStreamWrapper());
            abstractParameterStream.close();
        }
        map2.clear();
    }

    protected IResults executeWithParams(ArrayList<ParameterMetadata> arrayList, ArrayList<ArrayList<ParameterInputValue>> arrayList2, SStatement.ThrowCondition throwCondition) throws SQLException {
        return this.executeWithParams(arrayList, arrayList2, null, throwCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResults executeWithParams(ArrayList<ParameterMetadata> arrayList, ArrayList<ArrayList<ParameterInputValue>> arrayList2, ParameterGeneratedValues parameterGeneratedValues, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.checkCondition(this.m_preparedSql, throwCondition);
            object = new ExecutionContexts(arrayList, arrayList2, parameterGeneratedValues);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute((ExecutionContexts)object, this.m_warningListener);
            this.m_metadata = null;
            object2 = this.m_queryExecutor.getResults();
            return object2;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
        }
    }

    protected List<Pair<Integer, SQLException>> getBatchParamConversionErrors() {
        return this.m_batchParamConversionExceptions;
    }

    protected SParameterMetaData getOpenParamMetaData() {
        return this.m_openParamMetaData;
    }

    protected ArrayList<ParameterMetadata> getParameterMetadataList() {
        return this.m_parameterMetadata;
    }

    protected void setOpenParamMetaData(SParameterMetaData sParameterMetaData) {
        this.m_openParamMetaData = sParameterMetaData;
    }

    protected abstract SResultSetMetaData createResultSetMetaData(IResultSet var1) throws SQLException;

    private DataWrapper convertValueToTypeAsString(DataWrapper dataWrapper, TypeMetadata typeMetadata) throws IncorrectTypeException, SQLException {
        if (TypeUtilities.isCharacterType(dataWrapper.getType())) {
            return dataWrapper;
        }
        if (!this.stringRepresentationsCompatible(dataWrapper.getType(), typeMetadata.getType())) {
            dataWrapper = TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
        }
        dataWrapper.setVarChar(TypeConverter.toString(dataWrapper, typeMetadata));
        return dataWrapper;
    }

    private void setParameterInputData(int n, DataWrapper dataWrapper) throws SQLException {
        if (ParameterType.OUTPUT == this.m_parameterTypes.get(n - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n));
        }
        Integer n2 = n;
        AbstractParameterStream abstractParameterStream = this.m_parameterInputStreamData.get(n2);
        if (null != abstractParameterStream) {
            this.m_lastStreamsExecuted.remove(abstractParameterStream.getEqualityStreamWrapper());
            abstractParameterStream.close();
            this.m_parameterInputStreamData.remove(n2);
        }
        this.m_parameterInputValues.put(n2, dataWrapper);
    }

    private ParameterInputValue createConvertedParameterInputValue(DataWrapper dataWrapper, ParameterMetadata parameterMetadata) throws SQLException {
        assert (null != dataWrapper);
        assert (null != parameterMetadata);
        try {
            TypeMetadata typeMetadata = parameterMetadata.getTypeMetadata();
            if (Nullable.NO_NULLS == parameterMetadata.getNullable() && dataWrapper.isNull()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_NOT_NULLABLE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(parameterMetadata.getParameterNumber()));
            }
            if (2000 == dataWrapper.getType() && dataWrapper.isNull()) {
                dataWrapper.setNull(typeMetadata.getType());
            }
            dataWrapper = parameterMetadata.shouldConvertInputToString() ? this.convertValueToTypeAsString(dataWrapper, typeMetadata) : TypeConverter.toType(dataWrapper, typeMetadata, (IWarningListener)this.m_warningListener);
            return new ParameterInputValue(parameterMetadata, dataWrapper);
        }
        catch (IncorrectTypeException incorrectTypeException) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERSION_ERROR_INPUT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterMetadata.getParameterNumber()));
        }
    }

    private ParameterMetadata extractParameterMetadataForStream(int n) throws SQLException {
        short s = this.m_parameterMetadata.get(n).getTypeMetadata().getType();
        TypeMetadata typeMetadata = this.m_setMetadata.get(n);
        int n2 = null != typeMetadata ? (int)typeMetadata.getType() : 2000;
        if (!TypeConverter.canConvertStreamTo(n2, s)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n + 1));
        }
        return this.m_parameterMetadata.get(n);
    }

    private ArrayList<ArrayList<ParameterInputValue>> getInputParameterValues() throws SQLException {
        ArrayList<ParameterInputValue> arrayList = this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreamData);
        ArrayList<ArrayList<ParameterInputValue>> arrayList2 = new ArrayList<ArrayList<ParameterInputValue>>(1);
        arrayList2.add(arrayList);
        return arrayList2;
    }

    private ArrayList<ParameterInputValue> getInputParameterValues(Map<Integer, DataWrapper> map, Map<Integer, AbstractParameterStream> map2) throws SQLException {
        ArrayList<ParameterInputValue> arrayList = new ArrayList<ParameterInputValue>(this.m_numParameters);
        for (int i = 0; i < this.m_numParameters; ++i) {
            Object object;
            Object object2;
            if (ParameterType.OUTPUT == this.m_parameterTypes.get(i) || ParameterType.RETURN_VALUE == this.m_parameterTypes.get(i)) continue;
            Integer n = i + 1;
            if (map.containsKey(n)) {
                object2 = map.get(n);
                object = this.createConvertedParameterInputValue((DataWrapper)object2, this.m_parameterMetadata.get(i));
                arrayList.add((ParameterInputValue)object);
                continue;
            }
            object2 = map2.get(n);
            object = ((AbstractParameterStream)object2).getMetadata();
            if (null == object) {
                object = this.extractParameterMetadataForStream(i);
            }
            arrayList.add(new ParameterInputValue((ParameterMetadata)object, true, null));
        }
        return arrayList;
    }

    private void pushBatchParameterStreams() throws SQLException {
        try {
            int n = this.m_batchParameterInputStreamData.size();
            for (int i = 0; i < n; ++i) {
                this.pushParameterStreams(i + 1, this.m_batchParameterInputStreamData.get(i));
            }
            this.m_queryExecutor.finalizePushedParamData();
            this.m_currExecutionStreamSet.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void pushClearSingleBatchSetStreams() throws SQLException {
        try {
            for (Map.Entry<Integer, AbstractParameterStream> entry : this.m_parameterInputStreamData.entrySet()) {
                AbstractParameterStream abstractParameterStream = entry.getValue();
                int n = entry.getKey();
                if (!this.m_currExecutionStreamSet.add(abstractParameterStream.getEqualityStreamWrapper())) {
                    this.m_currExecutionStreamSet.clear();
                    throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
                }
                if (null == abstractParameterStream.getMetadata()) {
                    ParameterMetadata parameterMetadata = this.extractParameterMetadataForStream(n - 1);
                    abstractParameterStream.setParameterMetadata(parameterMetadata);
                }
                while (abstractParameterStream.hasMoreData()) {
                    this.m_queryExecutor.pushParamData(this.m_nextParamSetForStream, abstractParameterStream.getNextValue());
                }
                this.m_lastStreamsExecuted.remove(abstractParameterStream.getEqualityStreamWrapper());
                abstractParameterStream.close();
            }
            this.m_parameterInputStreamData.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
        finally {
            ++this.m_nextParamSetForStream;
        }
    }

    private void pushParameterStreams() throws SQLException {
        try {
            this.pushParameterStreams(1, this.m_parameterInputStreamData);
            this.m_queryExecutor.finalizePushedParamData();
            this.m_currExecutionStreamSet.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener);
        }
    }

    private void pushParameterStreams(int n, Map<Integer, AbstractParameterStream> map) throws ErrorException, IOException, BadDefaultParamException, SQLException {
        for (Map.Entry<Integer, AbstractParameterStream> entry : map.entrySet()) {
            AbstractParameterStream abstractParameterStream = entry.getValue();
            int n2 = entry.getKey();
            if (!this.m_currExecutionStreamSet.add(abstractParameterStream.getEqualityStreamWrapper())) {
                this.m_currExecutionStreamSet.clear();
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            if (null == abstractParameterStream.getMetadata()) {
                short s = this.m_parameterMetadata.get(n2 - 1).getTypeMetadata().getType();
                TypeMetadata typeMetadata = this.m_setMetadata.get(n2 - 1);
                int n3 = null != typeMetadata ? (int)typeMetadata.getType() : 2000;
                if (!TypeConverter.canConvertStreamTo(n3, s)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(n2));
                }
                abstractParameterStream.setParameterMetadata(this.m_parameterMetadata.get(n2 - 1));
            }
            this.m_lastStreamsExecuted.add(abstractParameterStream.getEqualityStreamWrapper());
            while (abstractParameterStream.hasMoreData()) {
                this.m_queryExecutor.pushParamData(n, abstractParameterStream.getNextValue());
            }
        }
    }

    private void updateParameterMetadata() throws ErrorException {
        if (!this.m_isSetMetadataFinal) {
            this.m_openParamMetaData = null;
            HashMap<Integer, TypeMetadata> hashMap = new HashMap<Integer, TypeMetadata>();
            for (Map.Entry<Integer, TypeMetadata> entry : this.m_setMetadata.entrySet()) {
                hashMap.put(entry.getKey(), TypeMetadata.copyOf(entry.getValue()));
            }
            this.m_queryExecutor.pushMappedParamTypes(hashMap);
            this.m_parameterMetadata = this.m_queryExecutor.getMetadataForParameters();
            assert (this.m_numParameters == this.m_parameterMetadata.size());
            this.m_isSetMetadataFinal = true;
        }
    }

    private boolean stringRepresentationsCompatible(int n, int n2) {
        Set<Integer> set = s_stringRepCompatibilityLookup.get(n);
        if (null == set) {
            return false;
        }
        return set.contains(n2);
    }

    protected TypeMetadata createExactNumMetadata(BigDecimal bigDecimal, int n) throws ErrorException {
        if (2 != n && 3 != n) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(n), ExceptionType.DATA);
        }
        if (null == bigDecimal) {
            return TypeMetadata.createTypeMetadata(n, true);
        }
        ConversionResult conversionResult = new ConversionResult();
        Pair<Short, Short> pair = ExactNumConverter.calculateSQLPrecisionScale(bigDecimal, conversionResult);
        if (ConversionResult.TypeConversionState.SUCCESS != conversionResult.getState()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NUMERIC_OVERFLOW.name(), String.valueOf(n), ExceptionType.DATA);
        }
        return TypeMetadata.createTypeMetadata(n, pair.key(), pair.value(), pair.key().shortValue(), true);
    }

    private TypeMetadata createMetadataForSqlType(int n) throws ErrorException {
        TypeMetadata typeMetadata = TypeUtilities.isIntegerType(n) ? TypeMetadata.createTypeMetadata(n, true) : (92 == n ? this.createTimeMetadata() : (93 == n ? this.createTimestampMetadata() : TypeMetadata.createTypeMetadata(n)));
        return typeMetadata;
    }

    private TypeMetadata createTimestampMetadata() throws ErrorException {
        return TypeMetadata.createTypeMetadata(93, (short)9, (short)0, 0, false);
    }

    private TypeMetadata createTimeMetadata() throws ErrorException {
        return TypeMetadata.createTypeMetadata(92, (short)3, (short)0, 0, false);
    }

    private static Map<Integer, Set<Integer>> initializeStringRepCompatibilityLookup() {
        List<Integer> list = Arrays.asList(1, 12, -1, -8, -9, -10);
        HashMap<Integer, Set<Integer>> hashMap = new HashMap<Integer, Set<Integer>>();
        for (Integer n : TypeUtilities.getSupportedSqlTypes()) {
            HashSet<Integer> hashSet = new HashSet<Integer>(list);
            hashSet.add(n);
            for (Integer n2 : TypeUtilities.getSupportedSqlTypes()) {
                if ((!TypeUtilities.isBinaryType(n) || !TypeUtilities.isBinaryType(n2)) && (!TypeUtilities.isIntegerType(n) || !TypeUtilities.isIntegerType(n2) && !TypeUtilities.isNumberType(n2)) && (!TypeUtilities.isApproximateNumericType(n) && !TypeUtilities.isExactNumericType(n) || !TypeUtilities.isApproximateNumericType(n2) && !TypeUtilities.isExactNumericType(n2)) && (-7 != n && 16 != n || -7 != n2 && 16 != n2)) continue;
                hashSet.add(n2);
            }
            hashMap.put(n, hashSet);
        }
        return hashMap;
    }

    protected static enum BatchExecResult {
        BATCH_EXEC_SUCCEEDED,
        BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION,
        BATCH_EXEC_NO_BATCHES;

    }
}

