/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jdbc.common;

import com.amazon.dsi.core.interfaces.IConnection;
import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.exceptions.JDBCMessageKey;
import com.amazon.jdbc.common.SCallableStatement;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.common.SConnectionHandle;
import com.amazon.jdbc.common.SDatabaseMetaData;
import com.amazon.jdbc.common.SPooledConnection;
import com.amazon.jdbc.common.SPreparedStatement;
import com.amazon.jdbc.common.SStatement;
import com.amazon.support.ILogger;
import com.amazon.support.exceptions.GeneralException;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public abstract class JDBCObjectFactory {
    private static JDBCObjectFactory s_factory = null;

    static JDBCObjectFactory getInstance() {
        return s_factory;
    }

    static void setInstance(JDBCObjectFactory jDBCObjectFactory) throws GeneralException {
        if (null == jDBCObjectFactory) {
            throw new GeneralException(1, JDBCMessageKey.INITIALIZE_FACTORY.name());
        }
        s_factory = jDBCObjectFactory;
    }

    protected JDBCObjectFactory() {
    }

    protected abstract SCallableStatement createCallableStatement(String var1, IStatement var2, SConnection var3, int var4) throws SQLException;

    protected abstract SConnection createConnection(IConnection var1, String var2) throws SQLException;

    protected abstract SConnectionHandle createConnectionHandle(SConnection var1, SPooledConnection var2) throws SQLException;

    protected abstract SDatabaseMetaData createDatabaseMetaData(SConnection var1, ILogger var2) throws SQLException;

    protected abstract SPreparedStatement createPreparedStatement(String var1, IStatement var2, SConnection var3, int var4) throws SQLException;

    protected abstract PooledConnection createPooledConnection(SConnection var1) throws SQLException;

    protected abstract SStatement createStatement(IStatement var1, SConnection var2, int var3) throws SQLException;
}

