/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.contouring;

import dr.geo.contouring.ContourAttrib;
import dr.geo.contouring.ContourPath;
import java.util.ArrayList;
import java.util.List;

public class ContourGenerator {
    private static final boolean DEBUG = false;
    private static final String kCancelMsg = "Method ContourGenerator.getContours() canceled by user.";
    private static final String kInconsistantArrMsg = "Inconsistant array sizes.";
    private static final String kArrSizeMsg = "Data arrays must have more than one row or column.";
    private static final String kNegLogDataMsg = "Function data must be > 0 for logarithmic intervals.";
    private static final int kBufSize = 1000;
    private static final int kMinNumPoints = 3;
    private List pathList = new ArrayList();
    private boolean cCalculated = false;
    private double[][] xArray;
    private double[][] yArray;
    private double[][] funcArray;
    private double[] xArr1D;
    private double[] yArr1D;
    private ContourAttrib[] cAttr;
    private float fracComplete = 0.0f;
    private boolean isCanceled = false;
    private double[] pathbufxt;
    private double[] pathbufyt;
    private int[] pathbufia;
    private int lnstrt;
    private int ignext;
    private int icont;
    private double cont;
    private int iss;
    private int iee;
    private int jss;
    private int jee;
    private int ima;
    private int iae;
    private int ibeg;
    private int jbeg;
    private int gi;
    private int gj;
    private double fij;
    private int idir;
    private int np = 0;
    private double wx = 0.0;
    private double wy = 0.0;

    public ContourGenerator(double[][] dArray, double[][] dArray2, double[][] dArray3, ContourAttrib[] contourAttribArray) {
        if (dArray2.length != dArray.length || dArray2.length != dArray3.length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray2[0].length != dArray[0].length || dArray2[0].length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1 || dArray[0].length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.cAttr = contourAttribArray;
        this.xArray = dArray;
        this.yArray = dArray2;
        this.funcArray = dArray3;
    }

    public ContourGenerator(double[] dArray, double[] dArray2, double[][] dArray3, ContourAttrib[] contourAttribArray) {
        if (dArray2.length != dArray3.length || dArray.length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.cAttr = contourAttribArray;
        this.xArr1D = dArray;
        this.yArr1D = dArray2;
        this.funcArray = dArray3;
    }

    public ContourGenerator(double[][] dArray, double[][] dArray2, double[][] dArray3, int n, boolean bl) {
        if (dArray2.length != dArray.length || dArray2.length != dArray3.length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray2[0].length != dArray[0].length || dArray2[0].length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1 || dArray[0].length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.xArray = dArray;
        this.yArray = dArray2;
        this.funcArray = dArray3;
        if (bl) {
            this.findLogIntervals(n);
        } else {
            this.findLinearIntervals(n);
        }
    }

    public ContourGenerator(double[] dArray, double[] dArray2, double[][] dArray3, int n, boolean bl) {
        if (dArray2.length != dArray3.length || dArray.length != dArray3[0].length) {
            throw new IllegalArgumentException(kInconsistantArrMsg);
        }
        if (dArray.length <= 1) {
            throw new IllegalArgumentException(kArrSizeMsg);
        }
        this.xArr1D = dArray;
        this.yArr1D = dArray2;
        this.funcArray = dArray3;
        if (bl) {
            this.findLogIntervals(n);
        } else {
            this.findLinearIntervals(n);
        }
    }

    public ContourPath[] getContours() throws InterruptedException {
        if (!this.cCalculated) {
            this.isCanceled = false;
            this.pathList.clear();
            this.computeContours();
            this.cAttr = null;
            this.funcArray = null;
            this.yArray = null;
            this.xArray = null;
            this.yArr1D = null;
            this.xArr1D = null;
            this.cCalculated = true;
            this.fracComplete = 1.0f;
        }
        int n = this.pathList.size();
        ContourPath[] contourPathArray = new ContourPath[n];
        for (int i = 0; i < n; ++i) {
            contourPathArray[i] = (ContourPath)this.pathList.get(i);
        }
        return contourPathArray;
    }

    public boolean done() {
        return this.cCalculated;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public float getProgress() {
        return this.fracComplete;
    }

    private void findLinearIntervals(int n) {
        int n2;
        double d = Double.MAX_VALUE;
        double d2 = -d;
        int n3 = this.funcArray.length;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.funcArray[i].length;
            for (n2 = 0; n2 < n4; ++n2) {
                double d3 = this.funcArray[i][n2];
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
        }
        this.cAttr = new ContourAttrib[n];
        double d4 = (d2 - d) / (double)(n + 1);
        for (n2 = 0; n2 < n; ++n2) {
            this.cAttr[n2] = new ContourAttrib(d + (double)(n2 + 1) * d4);
        }
    }

    private void findLogIntervals(int n) {
        double d = Double.MAX_VALUE;
        double d2 = -d;
        int n2 = this.funcArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = this.funcArray[i].length;
            for (int j = 0; j < n3; ++j) {
                double d3 = this.funcArray[i][j];
                d = Math.min(d, d3);
                d2 = Math.max(d2, d3);
            }
        }
        if (d < 0.0) {
            throw new IllegalArgumentException(kNegLogDataMsg);
        }
        this.cAttr = new ContourAttrib[n];
        double d4 = Math.log(d);
        double d5 = (Math.log(d2) - d4) / (double)(n + 1);
        for (int i = 0; i < n; ++i) {
            this.cAttr[i] = new ContourAttrib(Math.exp(d4 + (double)(i + 1) * d5));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void computeContours() throws InterruptedException {
        int n = this.cAttr.length;
        int n2 = 0;
        int n3 = 0;
        if (this.xArray != null) {
            n3 = this.xArray.length;
            n2 = this.xArray[0].length;
        } else {
            n2 = this.xArr1D.length;
            n3 = this.yArr1D.length;
        }
        this.pathbufxt = new double[1000];
        this.pathbufyt = new double[1000];
        this.pathbufia = new int[3000];
        this.lnstrt = 1;
        this.ignext = 0;
        this.icont = 0;
        while (true) {
            if (this.icont >= n) {
                this.pathbufxt = null;
                this.pathbufyt = null;
                this.pathbufia = null;
                return;
            }
            if (this.isCanceled) {
                throw new InterruptedException(kCancelMsg);
            }
            this.cont = this.cAttr[this.icont].getLevel();
            this.iss = 1;
            this.iee = n2;
            this.jss = 1;
            this.jee = n3;
            boolean bl = false;
            do {
                this.FlagContourPassings();
                boolean bl2 = false;
                block16: do {
                    int n4;
                    int n5;
                    if (!bl2) {
                        this.ima = 1;
                        this.ibeg = this.iss - 1;
                        this.jbeg = this.jss;
                    }
                    block17: do {
                        if (!bl2) {
                            n5 = 0;
                            n4 = 0;
                            do {
                                switch (this.ima) {
                                    case 1: {
                                        ++this.ibeg;
                                        if (this.ibeg != this.iee) break;
                                        this.ima = 2;
                                        break;
                                    }
                                    case 2: {
                                        ++this.jbeg;
                                        if (this.jbeg != this.jee) break;
                                        this.ima = 3;
                                        break;
                                    }
                                    case 3: {
                                        --this.ibeg;
                                        if (this.ibeg != this.iss) break;
                                        this.ima = 4;
                                        break;
                                    }
                                    case 4: {
                                        --this.jbeg;
                                        if (this.jbeg != this.jss) break;
                                        this.ima = 5;
                                        break;
                                    }
                                    case 5: {
                                        continue block17;
                                    }
                                }
                                if (this.funcArray[this.jbeg - 1][this.ibeg - 1] <= this.cont) {
                                    n5 = 1;
                                    n4 = 0;
                                    continue;
                                }
                                if (n5 != 1) continue;
                                n4 = 1;
                            } while (n4 == 0);
                            this.gi = this.ibeg;
                            this.gj = this.jbeg;
                            this.fij = this.funcArray[this.jbeg - 1][this.ibeg - 1];
                            switch (this.ima) {
                                case 1: {
                                    this.Routine_L21();
                                    break;
                                }
                                case 2: {
                                    if (this.gj != this.jss) {
                                        if (this.Routine_L31()) break;
                                        this.Routine_L21();
                                        break;
                                    }
                                    this.Routine_L21();
                                    break;
                                }
                                case 3: {
                                    if (this.gi != this.iee) {
                                        if (this.Routine_L41()) break;
                                        this.Routine_L21();
                                        break;
                                    }
                                    if (this.Routine_L31()) break;
                                    this.Routine_L21();
                                    break;
                                }
                                case 4: {
                                    if (this.gj != this.jee) {
                                        if (this.Routine_L51()) break;
                                        this.Routine_L21();
                                        break;
                                    }
                                    if (this.Routine_L41()) break;
                                    this.Routine_L21();
                                    break;
                                }
                                case 5: {
                                    if (this.Routine_L51()) break;
                                    this.Routine_L21();
                                    break;
                                }
                            }
                        }
                        bl2 = false;
                        this.lnstrt = 1;
                        this.ignext = 0;
                        this.accumContour(this.np, this.icont, this.pathbufxt, this.pathbufyt, this.cAttr[this.icont]);
                    } while (this.ima != 5);
                    if (this.iae == 0) continue;
                    n5 = this.iae;
                    for (n4 = 1; n4 <= n5; ++n4) {
                        if (this.pathbufia[n4 - 1] == 0) continue;
                        this.gi = this.pathbufia[n4 - 1] / 1000;
                        this.gj = this.pathbufia[n4 - 1] - this.gi * 1000;
                        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
                        this.pathbufia[n4 - 1] = 0;
                        this.Routine_L21();
                        bl2 = true;
                        continue block16;
                    }
                } while (bl2);
                bl = false;
                if (this.iee == n2) {
                    if (this.jee == n3) continue;
                    this.jss = this.jee;
                    this.jee = n3;
                    bl = true;
                    continue;
                }
                this.iss = this.iee;
                this.iee = n2;
                bl = true;
            } while (bl);
            this.fracComplete = (float)(this.icont + 1) / (float)n;
            ++this.icont;
        }
    }

    private void FlagContourPassings() {
        this.iae = 0;
        int n = this.jee - 1;
        for (int i = this.jss + 1; i <= n; ++i) {
            boolean bl = false;
            int n2 = this.iae;
            int n3 = this.iee;
            for (int j = this.iss; j <= n3; ++j) {
                if (this.funcArray[i - 1][j - 1] <= this.cont) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                ++this.iae;
                this.pathbufia[this.iae - 1] = j * 1000 + i;
                bl = false;
                if (this.iae != 3000) continue;
                if (i > this.jss + 1) {
                    this.iae = n2;
                    this.jee = i;
                } else {
                    this.jee = Math.min(i + 1, this.jee);
                    this.iee = j;
                }
                return;
            }
        }
    }

    private void Routine_L21() {
        do {
            --this.gi;
            if (this.gi < this.iss) {
                return;
            }
            this.idir = 1;
            if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
                if (this.iae != 0) {
                    int n = this.gi * 1000 + this.gj + 1000;
                    int n2 = this.iae;
                    for (int i = 1; i <= n2; ++i) {
                        if (this.pathbufia[i - 1] != n) continue;
                        this.pathbufia[i - 1] = 0;
                        break;
                    }
                }
                this.doInterpolation();
                return;
            }
            this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        } while (!this.Routine_L31());
    }

    private boolean Routine_L31() {
        --this.gj;
        if (this.gj < this.jss) {
            return true;
        }
        this.idir = 2;
        if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
            this.doInterpolation();
            return true;
        }
        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        return this.Routine_L41();
    }

    private boolean Routine_L41() {
        ++this.gi;
        if (this.gi > this.iee) {
            return true;
        }
        this.idir = 3;
        if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
            this.doInterpolation();
            return true;
        }
        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        return this.Routine_L51();
    }

    private boolean Routine_L51() {
        ++this.gj;
        this.idir = 4;
        if (this.gj > this.jee) {
            return true;
        }
        if (this.funcArray[this.gj - 1][this.gi - 1] <= this.cont) {
            this.doInterpolation();
            return true;
        }
        this.fij = this.funcArray[this.gj - 1][this.gi - 1];
        return false;
    }

    private void doInterpolation() {
        double d = this.funcArray[this.gj - 1][this.gi - 1];
        double d2 = (this.cont - d) / (this.fij - d);
        if (d2 == 0.0) {
            ++this.ignext;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.xArray != null) {
            d5 = this.xArray[this.gj - 1][this.gi - 1];
            d6 = this.yArray[this.gj - 1][this.gi - 1];
            switch (this.idir) {
                case 1: {
                    d3 = d5 + d2 * (this.xArray[this.gj - 1][this.gi + 1 - 1] - d5);
                    d4 = d6 + d2 * (this.yArray[this.gj - 1][this.gi + 1 - 1] - d6);
                    break;
                }
                case 2: {
                    d3 = d5 + d2 * (this.xArray[this.gj + 1 - 1][this.gi - 1] - d5);
                    d4 = d6 + d2 * (this.yArray[this.gj + 1 - 1][this.gi - 1] - d6);
                    break;
                }
                case 3: {
                    d3 = d5 + d2 * (this.xArray[this.gj - 1][this.gi - 1 - 1] - d5);
                    d4 = d6 + d2 * (this.yArray[this.gj - 1][this.gi - 1 - 1] - d6);
                    break;
                }
                case 4: {
                    d3 = d5 + d2 * (this.xArray[this.gj - 1 - 1][this.gi - 1] - d5);
                    d4 = d6 + d2 * (this.yArray[this.gj - 1 - 1][this.gi - 1] - d6);
                }
            }
        } else {
            d5 = this.xArr1D[this.gi - 1];
            d6 = this.yArr1D[this.gj - 1];
            switch (this.idir) {
                case 1: {
                    d3 = d5 + d2 * (this.xArr1D[this.gi + 1 - 1] - d5);
                    d4 = d6;
                    break;
                }
                case 2: {
                    d3 = d5;
                    d4 = d6 + d2 * (this.yArr1D[this.gj + 1 - 1] - d6);
                    break;
                }
                case 3: {
                    d3 = d5 + d2 * (this.xArr1D[this.gi - 1 - 1] - d5);
                    d4 = d6;
                    break;
                }
                case 4: {
                    d3 = d5;
                    d4 = d6 + d2 * (this.yArr1D[this.gj - 1 - 1] - d6);
                }
            }
        }
        if (this.lnstrt == 1) {
            this.np = 1;
            this.pathbufxt[this.np - 1] = d3;
            this.pathbufyt[this.np - 1] = d4;
            this.wx = d3;
            this.wy = d4;
            this.lnstrt = 0;
        } else {
            boolean bl = false;
            if (this.ignext == 2) {
                if (d3 == this.pathbufxt[this.np - 1] && d4 == this.pathbufyt[this.np - 1]) {
                    this.ignext = 0;
                    bl = true;
                } else {
                    this.ignext = 1;
                }
            }
            if (!bl) {
                ++this.np;
                this.pathbufxt[this.np - 1] = d3;
                this.pathbufyt[this.np - 1] = d4;
                if (this.np == 1000) {
                    this.accumContour(this.np, this.icont, this.pathbufxt, this.pathbufyt, this.cAttr[this.icont]);
                    this.pathbufxt[0] = this.pathbufxt[this.np - 1];
                    this.pathbufyt[0] = this.pathbufyt[this.np - 1];
                    this.np = 1;
                }
                if (d3 == this.wx && d4 == this.wy) {
                    return;
                }
            }
        }
        switch (this.idir) {
            case 1: {
                ++this.gi;
                if (this.Routine_L51()) break;
                this.Routine_L21();
                break;
            }
            case 2: {
                ++this.gj;
                this.Routine_L21();
                break;
            }
            case 3: {
                --this.gi;
                if (this.Routine_L31()) break;
                this.Routine_L21();
                break;
            }
            case 4: {
                --this.gj;
                if (this.Routine_L41()) break;
                this.Routine_L21();
            }
        }
    }

    private void accumContour(int n, int n2, double[] dArray, double[] dArray2, ContourAttrib contourAttrib) {
        if (n < 3) {
            return;
        }
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[n];
        System.arraycopy(dArray, 0, dArray3, 0, n);
        System.arraycopy(dArray2, 0, dArray4, 0, n);
        ContourPath contourPath = new ContourPath(contourAttrib, n2, dArray3, dArray4);
        this.pathList.add(contourPath);
    }
}

