/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph.annotations;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.json.stream.JsonGenerator;
import org.af.gMCP.gui.graph.annotations.Annotation;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;

public class Rectangle
extends Annotation {
    int width;
    int height;
    Color backColor = Color.WHITE;

    public Rectangle(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public Rectangle(int x, int y, int width, int height, AnnotationPanel nl) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.nl = nl;
    }

    @Override
    public void writeObject(JsonGenerator gen) {
    }

    @Override
    public Dimension paintObject(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(this.backColor);
        g.fill3DRect((int)((double)this.x * this.nl.getZoom()), (int)((double)this.y * this.nl.getZoom()), (int)((double)this.width * this.nl.getZoom()), (int)((double)this.height * this.nl.getZoom()), true);
        g.setColor(this.color);
        g.draw3DRect((int)((double)this.x * this.nl.getZoom()), (int)((double)this.y * this.nl.getZoom()), (int)((double)this.width * this.nl.getZoom()), (int)((double)this.height * this.nl.getZoom()), true);
        return new Dimension(this.width, this.height);
    }

    @Override
    public String getLaTeX() {
        return null;
    }

    @Override
    public Annotation readJSON(String json) {
        return null;
    }

    @Override
    public boolean inYou(int x, int y) {
        return (double)x / this.nl.getZoom() - (double)this.x > 0.0 && (double)x / this.nl.getZoom() - (double)this.x < (double)this.width && (double)y / this.nl.getZoom() - (double)this.y > 0.0 && (double)y / this.nl.getZoom() - (double)this.y < (double)this.height;
    }
}

