/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable;

import com.amazon.dsi.dataengine.interfaces.IColumn;
import com.amazon.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.amazon.sqlengine.executor.etree.ETDataRequest;
import com.amazon.sqlengine.executor.etree.IMemManagerAgent;
import com.amazon.sqlengine.executor.etree.relation.ETRelationalExpr;
import com.amazon.sqlengine.executor.etree.temptable.DataStore;
import com.amazon.sqlengine.executor.etree.temptable.IRowView;
import com.amazon.sqlengine.executor.etree.temptable.ITemporaryTable;
import com.amazon.sqlengine.executor.etree.temptable.InMemTable;
import com.amazon.sqlengine.executor.etree.temptable.LongDataStore;
import com.amazon.sqlengine.executor.etree.temptable.TemporaryTableBuilder;
import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.util.DataRetrievalUtil;
import com.amazon.sqlengine.utilities.ExternalAlgorithmUtil;
import com.amazon.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;

public class TemporaryTable
implements ITemporaryTable {
    private static final long EIGHT_KB = 8192L;
    private List<IColumn> m_metadata;
    private DataStore m_dataStore;
    private InMemTable m_inMemTable;
    private LongDataStore m_longDataStore;
    private boolean[] m_isLongData;
    private TemporaryTableBuilder.TemporaryTableProperties m_properties;
    private long m_allocatedMemory;
    private boolean m_startedFetch;
    private int m_rowInCurrentBlock = -1;
    private boolean m_inMemTableHasData;
    private boolean[] m_needsData;
    private IMemManagerAgent m_memManAgent = null;
    private long m_rowCount = -1L;
    private boolean m_isOpen = false;

    public TemporaryTable(List<? extends IColumn> list, TemporaryTableBuilder.TemporaryTableProperties temporaryTableProperties, boolean[] blArray) throws ErrorException {
        this.m_metadata = new ArrayList<IColumn>(list);
        this.m_properties = temporaryTableProperties;
        this.m_needsData = (boolean[])blArray.clone();
        long l = ExternalAlgorithmUtil.calculateRowSize(this.m_metadata, this.m_needsData, this.m_properties.m_maxDataLen);
        int n = 0;
        if (0L < l) {
            n = (int)((double)this.m_properties.m_blockSize * 0.1 / (double)l) + 1;
        }
        this.m_inMemTable = new InMemTable(this.m_metadata.toArray(new IColumn[0]), this.m_properties.m_maxDataLen, n, this.m_needsData, this.m_properties.m_logger);
        this.prepareForLongData();
    }

    @Override
    public boolean isOpen() {
        return this.m_isOpen;
    }

    @Override
    public void open() throws ErrorException {
        if (0L == this.m_allocatedMemory) {
            throw new IllegalStateException("Memory unassigned.");
        }
        this.m_startedFetch = false;
        try {
            this.m_dataStore = new DataStore(this.m_properties, this.m_metadata.toArray(new IColumn[0]));
            this.m_inMemTableHasData = false;
        }
        catch (Exception exception) {
            if (null != this.m_dataStore) {
                this.m_dataStore.destroy();
                this.m_dataStore = null;
            }
            if (exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            throw SQLEngineExceptionFactory.runtimeException(exception);
        }
        this.m_isOpen = true;
    }

    @Override
    public void close(boolean bl) {
        if (null != this.m_dataStore) {
            this.m_dataStore.destroy();
            this.m_dataStore = null;
        }
        if (null != this.m_longDataStore) {
            this.m_longDataStore.destroy();
            this.m_longDataStore = null;
        }
        this.m_inMemTable.clear();
        if (!bl) {
            this.m_inMemTable.setMemLimit(0L);
            this.m_memManAgent.recycleMemory(this.m_allocatedMemory);
            this.m_memManAgent.unregisterConsumer();
        }
        this.m_rowCount = -1L;
        this.m_isOpen = false;
    }

    @Override
    public long getRowCount() {
        return this.m_rowCount;
    }

    @Override
    public void reset() throws ErrorException {
        if (this.m_rowCount == -1L) {
            throw new IllegalStateException("Resetting temporary table before data has been set.");
        }
        this.prepareForFetch();
        this.m_dataStore.reset();
    }

    @Override
    public boolean moveToNextRow() throws ErrorException {
        this.prepareForFetch();
        return this.m_dataStore.moveToNextRow();
    }

    @Override
    public boolean retrieveData(int n, ETDataRequest eTDataRequest) throws ErrorException {
        if (!this.m_startedFetch) {
            throw new UnsupportedOperationException("Cannot retrieveData without move()");
        }
        return DataRetrievalUtil.retrieveFromRowView(n, this.m_isLongData[n], eTDataRequest, (IRowView)this.m_dataStore, this.m_longDataStore);
    }

    @Override
    public void writeFromRelation(ETRelationalExpr eTRelationalExpr) throws ErrorException {
        int n;
        int n2 = this.m_metadata.size();
        short[] sArray = new short[n2];
        ETDataRequest[] eTDataRequestArray = new ETDataRequest[n2];
        for (n = 0; n < eTDataRequestArray.length; ++n) {
            eTDataRequestArray[n] = new ETDataRequest(this.m_metadata.get(n));
            sArray[n] = this.m_metadata.get(n).getTypeMetadata().getType();
        }
        this.m_rowCount = 0L;
        while (eTRelationalExpr.move()) {
            ++this.m_rowCount;
            this.appendRow();
            n = this.m_rowInCurrentBlock;
            block6: for (int i = 0; i < n2; ++i) {
                if (!eTRelationalExpr.getDataNeeded(i)) continue;
                switch (sArray[i]) {
                    case -4: 
                    case -3: 
                    case -2: {
                        if (this.m_isLongData[i]) {
                            this.m_inMemTable.setFileMarker(n, i, this.m_longDataStore.put(i, eTRelationalExpr));
                            continue block6;
                        }
                        this.m_inMemTable.writeData(n, i, eTRelationalExpr);
                        continue block6;
                    }
                    case -10: 
                    case -9: 
                    case -8: 
                    case -1: 
                    case 1: 
                    case 12: {
                        if (this.m_isLongData[i]) {
                            this.m_inMemTable.setFileMarker(n, i, this.m_longDataStore.put(i, eTRelationalExpr));
                            continue block6;
                        }
                        this.m_inMemTable.writeData(n, i, eTRelationalExpr);
                        continue block6;
                    }
                    default: {
                        this.m_inMemTable.writeData(n, i, eTRelationalExpr);
                    }
                }
            }
        }
    }

    @Override
    public void registerManagerAgent(IMemManagerAgent iMemManagerAgent) {
        this.m_memManAgent = iMemManagerAgent;
    }

    @Override
    public long assign(long l) {
        long l2 = this.getRequiredMemory();
        if (this.m_allocatedMemory > l2) {
            return 0L;
        }
        long l3 = l2 - this.m_allocatedMemory;
        if (l3 >= l) {
            this.m_allocatedMemory += l;
            this.m_inMemTable.setMemLimit(this.m_properties.m_blockSize);
            return l;
        }
        this.m_allocatedMemory += l3;
        return l3;
    }

    @Override
    public long getRequiredMemory() {
        return this.m_properties.m_blockSize + (long)this.m_inMemTable.getMemOverhead() + (this.m_longDataStore == null ? 0L : 8192L);
    }

    private void appendCurrentBlockToDataStore() throws ErrorException {
        assert (this.m_inMemTableHasData);
        this.m_dataStore.put(this.m_inMemTable.toRowBlock());
        this.m_inMemTable.clear();
        this.m_inMemTableHasData = false;
        this.m_rowInCurrentBlock = -1;
    }

    private void prepareForFetch() throws ErrorException {
        if (!this.m_startedFetch) {
            this.m_dataStore.giveBlock();
            if (this.m_inMemTableHasData) {
                this.appendCurrentBlockToDataStore();
            }
            this.m_startedFetch = true;
        }
    }

    private void prepareForLongData() throws ErrorException {
        this.m_isLongData = new boolean[this.m_metadata.size()];
        for (int i = 0; i < this.m_metadata.size(); ++i) {
            this.m_isLongData[i] = ColumnSizeCalculator.isLongData(this.m_metadata.get(i), this.m_properties.m_maxDataLen);
            if (!this.m_isLongData[i] || null != this.m_longDataStore) continue;
            this.m_longDataStore = new LongDataStore(this.m_properties.m_storageDir, 8192L, this.m_properties.m_logger);
        }
    }

    private void appendRow() throws ErrorException {
        if (this.m_startedFetch) {
            throw new UnsupportedOperationException("Cannot appendRow after fetch started.");
        }
        int n = this.m_inMemTable.appendRow();
        if (0 > n) {
            this.appendCurrentBlockToDataStore();
            n = this.m_inMemTable.appendRow();
        }
        this.m_rowInCurrentBlock = n;
        this.m_inMemTableHasData = true;
    }
}

