/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MatrixRotationOperator
extends AbstractAdaptableOperator {
    private double rotationWindow;
    private final MatrixParameterInterface param;
    private static final double TWO_PI = Math.PI * 2;
    public static final String MATRIX_ROTATION_OPERATOR = "matrixRotationOperator";
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private static final String ROTATION_WINDOW = "rotationWindow";

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            double d = xMLObject.getDoubleAttribute(ROTATION_WINDOW);
            double d2 = xMLObject.getDoubleAttribute("weight");
            return new MatrixRotationOperator(matrixParameterInterface, d, d2);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class), AttributeRule.newDoubleRule(ROTATION_WINDOW), AttributeRule.newDoubleRule("weight")};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return MatrixRotationOperator.class;
        }

        @Override
        public String getParserName() {
            return MatrixRotationOperator.MATRIX_ROTATION_OPERATOR;
        }
    };

    MatrixRotationOperator(MatrixParameterInterface matrixParameterInterface, double d, double d2) {
        this.param = matrixParameterInterface;
        this.rotationWindow = d;
        this.setWeight(d2);
    }

    @Override
    public String getOperatorName() {
        return MATRIX_ROTATION_OPERATOR;
    }

    @Override
    public double doOperation() {
        int n = this.param.getRowDimension();
        int n2 = MathUtils.nextInt(n);
        int n3 = MathUtils.nextInt(n);
        while (n2 == n3) {
            n3 = MathUtils.nextInt(n);
        }
        double d = Math.PI * 2 * this.rotationWindow * (MathUtils.nextDouble() - 0.5);
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int i = 0; i < this.param.getColumnDimension(); ++i) {
            double d4 = this.param.getParameterValue(n2, i);
            double d5 = this.param.getParameterValue(n3, i);
            this.param.setParameterValueQuietly(n2, i, d4 * d3 - d5 * d2);
            this.param.setParameterValueQuietly(n3, i, d4 * d2 + d5 * d3);
        }
        this.param.fireParameterChangedEvent();
        return 0.0;
    }

    @Override
    protected void setAdaptableParameterValue(double d) {
        this.rotationWindow = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return this.rotationWindow;
    }

    @Override
    public double getRawParameter() {
        return this.rotationWindow;
    }

    @Override
    public String getAdaptableParameterName() {
        return "Rotation fraction";
    }
}

