/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects;

import java.util.Arrays;

public class IntList {
    private static final int DEFAULT_CAPACITY = 10;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private int[] elements;
    private int size;

    public IntList() {
        this(10);
    }

    public IntList(int initialCapacity) {
        this.elements = new int[initialCapacity];
        this.size = 0;
    }

    public IntList(int ... values) {
        this.size = values.length;
        this.elements = new int[this.size];
        System.arraycopy(values, 0, this.elements, 0, this.size);
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity - this.elements.length > 0) {
            int oldCapacity = this.elements.length;
            int newCapacity = oldCapacity + (oldCapacity >> 1);
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = 0x7FFFFFF7;
            }
            this.elements = Arrays.copyOf(this.elements, newCapacity);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.getQuick(index);
    }

    public int getQuick(int index) {
        return this.elements[index];
    }

    public void replace(int index, int element) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.replaceQuick(index, element);
    }

    public void replaceQuick(int index, int element) {
        this.elements[index] = element;
    }

    public boolean add(int element) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = element;
        return true;
    }

    public boolean addAt(int index, int element) {
        this.ensureCapacity(index);
        this.elements[index] = element;
        return true;
    }

    public boolean addAll(IntList list) {
        this.ensureCapacity(this.size + list.size);
        System.arraycopy(list.elements, 0, this.elements, this.size, list.size);
        this.size += list.size;
        return true;
    }

    public boolean remove(int value) {
        boolean removed = false;
        for (int index = 0; index < this.size && !removed; ++index) {
            if (value != this.elements[index]) continue;
            this.removeAt(index);
            removed = true;
        }
        return removed;
    }

    public void removeAt(int index) {
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numMoved);
        }
        --this.size;
    }

    public void removeRange(int fromIndex, int toIndex) {
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elements, toIndex, this.elements, fromIndex, numMoved);
        this.size -= toIndex - fromIndex;
    }

    public void clear() {
        this.size = 0;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.elements, this.size);
    }
}

