\name{dbListConnections-methods}
\docType{methods}
\alias{dbListConnections}
\alias{dbListResults}
\alias{dbListConnections,OraDriver-method}
\alias{dbListConnections,ExtDriver-method}
\alias{dbListResults,OraConnection-method}
\title{
  List items from Oracle objects 
}
\description{
   These methods are straight-forward implementations of the corresponding
   generic functions.
}
\usage{
\S4method{dbListConnections}{OraDriver}(drv, ...)
\S4method{dbListConnections}{ExtDriver}(drv, ...)
\S4method{dbListResults}{OraConnection}(conn, ...)
}
\arguments{
  \item{drv}{an \code{OraDriver} or \code{ExtDriver}.}
  \item{conn}{an \code{OraConnection}.}
  \item{\dots}{currently unused.}
}
\value{
  \item{dbListConnections}{
    A list of all connections associated with driver.
  }
  \item{dbListResults}{
    A list of all result sets associated with connection.
  }
}
\details{
  \describe{
    \item{dbListConnections}{
      implementation return a list of all the associated connections.
      It shows information about all the associated connections.
    }
    \item{dbListResults}{
      implementation return a list of all associated result sets.
      It shows information about all associated result sets.
    }
  }
}
\section{References}{
  For the Oracle Database documentation see
  \url{https://docs.oracle.com/en/}.
}
\seealso{
  \code{\link{Oracle}},
  \code{\link[DBI]{dbGetInfo}},
  \code{\link[DBI]{dbColumnInfo}},
  \code{\link[DBI]{dbDriver}},
  \code{\link[DBI]{dbConnect}},
  \code{\link[DBI]{dbSendQuery}}
}

\examples{
  \dontrun{
    drv <- dbDriver("Oracle")
    con1 <- dbConnect(drv, "scott", "tiger")
    res1 <- dbSendQuery(con1, "select * from emp where deptno = 10")
    res2 <- dbSendQuery(con1, "select * from emp where deptno = 20")
    con2 <- dbConnect(drv, "scott", "tiger")
    res3 <- dbSendQuery(con2, "select * from dept")

    ## get all active statements
    for(con in dbListConnections(drv))
      for (res in dbListResults(con))
        print(dbGetStatement(res))
  }
}
\keyword{methods}
\keyword{interface}
\keyword{database}
