/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.shrinkage;

import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class TemperOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    public static final String TEMPER_OPERATOR = "temperOperator";
    private static final String TARGET_PARAMETER = "target";
    private static final String RATE = "rate";
    private final Parameter parameter;
    private final Parameter target;
    private final double rate;
    private double currentCount;
    private final double[] startValues;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class), new ElementRule("target", new XMLSyntaxRule[]{new XORRule(new ElementRule(Parameter.class), new ElementRule(Double.class))}), AttributeRule.newDoubleRule("rate")};

        @Override
        public String getParserName() {
            return TemperOperator.TEMPER_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter;
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter2 = (Parameter)xMLObject.getChild(Parameter.class);
            XMLObject xMLObject2 = xMLObject.getChild(TemperOperator.TARGET_PARAMETER);
            Parameter parameter3 = parameter = xMLObject2.getChild(0) instanceof Parameter ? (Parameter)xMLObject2.getChild(Parameter.class) : new Parameter.Default(xMLObject2.getDoubleChild(0));
            if (parameter.getDimension() > parameter2.getDimension()) {
                throw new XMLParseException("Target parameter cannot have more dimensions than the tempered parameter.");
            }
            double d2 = xMLObject.getAttribute(TemperOperator.RATE, 0.0);
            if (d2 < 0.0) {
                throw new XMLParseException("Rate cannot be negative");
            }
            return new TemperOperator(parameter2, parameter, d2, d);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Tempers (anneals) a parameter from starting value to target value.";
        }

        @Override
        public Class getReturnType() {
            return TemperOperator.class;
        }
    };

    public TemperOperator(Parameter parameter, Parameter parameter2, double d, double d2) {
        this.parameter = parameter;
        this.target = parameter2;
        this.rate = d;
        this.startValues = parameter.getParameterValues();
        this.currentCount = 0.0;
        this.setWeight(d2);
    }

    @Override
    public String getOperatorName() {
        return "bayesianBridgeGibbsOperator";
    }

    @Override
    public double doOperation() {
        this.currentCount += 1.0;
        double d = this.currentCount * Math.exp(-this.rate);
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            double d2 = this.parameter.getParameterValue(i);
            double d3 = this.target.getParameterValue(i % this.target.getDimension());
            if (d < 2.3) {
                double d4 = this.startValues[i];
                double d5 = d4 + (d4 - d3) * (Math.exp(-d) - 1.0);
                this.parameter.setParameterValue(i, d5);
                continue;
            }
            if (d2 == d3) continue;
            this.parameter.setParameterValue(i, d3);
        }
        return 0.0;
    }
}

