/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;

public class BitMoveOperator
extends SimpleMCMCOperator {
    private Parameter bitsParameter = null;
    private Parameter valuesParameter = null;
    private int numBitsToMove = 1;

    public BitMoveOperator(Parameter parameter, Parameter parameter2, int n, double d) {
        this.bitsParameter = parameter;
        this.valuesParameter = parameter2;
        if (parameter2 != null && parameter.getDimension() != parameter2.getDimension()) {
            throw new IllegalArgumentException("bits parameter must be same length as values parameter");
        }
        this.numBitsToMove = n;
        this.setWeight(d);
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = this.bitsParameter.getDimension();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < n2; ++n) {
            if (this.bitsParameter.getParameterValue(n) == 1.0) {
                arrayList.add(n);
                continue;
            }
            arrayList2.add(n);
        }
        if (arrayList.size() >= this.numBitsToMove && arrayList2.size() >= this.numBitsToMove) {
            for (n = 0; n < this.numBitsToMove; ++n) {
                int n3 = (Integer)arrayList.remove(MathUtils.nextInt(arrayList.size()));
                int n4 = (Integer)arrayList2.remove(MathUtils.nextInt(arrayList2.size()));
                this.bitsParameter.setParameterValue(n3, 0.0);
                this.bitsParameter.setParameterValue(n4, 1.0);
                if (this.valuesParameter == null) continue;
                double d = this.valuesParameter.getParameterValue(n3);
                double d2 = this.valuesParameter.getParameterValue(n4);
                this.valuesParameter.setParameterValue(n3, d2);
                this.valuesParameter.setParameterValue(n4, d);
            }
        } else {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("bitMove(");
        stringBuilder.append(this.bitsParameter.getParameterName());
        if (this.valuesParameter != null) {
            stringBuilder.append(", ").append(this.valuesParameter.getParameterName());
        }
        stringBuilder.append(", ").append(this.numBitsToMove).append(")");
        return stringBuilder.toString();
    }

    public final String getPerformanceSuggestion() {
        return "no performance suggestion";
    }

    public String toString() {
        return this.getOperatorName();
    }
}

